/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FileUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.util.HostUtil;

public class PlatformFileUtil {
    public static String getTmpDir() {
        String tmpDir = null;
        String homeDir = System.getProperty("user.home");
        if (homeDir != null) {
            tmpDir = new Path(homeDir).append("tmp").toOSString();
        }
        return tmpDir;
    }

    public static File findFirstFilebyExtension(File searchPath, String ext) {
        File[] allFiles = searchPath.listFiles(new ExtFilter(ext));
        if (allFiles == null || allFiles.length == 0) {
            return null;
        }
        return allFiles[0];
    }

    public static boolean existsFile(String path) {
        return PlatformInstances.getBuildCommandUtil(null).existsLocalfile(path);
    }

    public static boolean isWindowsPath(String path) {
        char drive = path.charAt(0);
        char delimiter = path.charAt(1);
        return (drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z') && delimiter == ':';
    }

    public static boolean isLinuxPath(String path) {
        return !PlatformFileUtil.isWindowsPath(path);
    }

    public static String extractTarGzFile(String filePath, String extractDirName) {
        IPath dirPath = new Path(filePath).removeLastSegments(1);
        String filename = new Path(filePath).lastSegment();
        if (filePath.endsWith(".tar.gz")) {
            File extractDir = dirPath.append(extractDirName).toFile();
            if (!extractDir.exists()) {
                FileUtil.createDirectory((File)extractDir);
            } else {
                FileUtil.recursiveDelete((File)extractDir);
                FileUtil.createDirectory((File)extractDir);
            }
            try {
                String destPath = new Path(extractDir.getAbsolutePath()).append(filename).toOSString();
                FileUtil.copyTo((String)filePath, (String)destPath);
                String command = String.format("tar xf \"%s\"", filename);
                if (HostUtil.execute(command, extractDir.getAbsolutePath())) {
                    return extractDir.getAbsolutePath();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtil.recursiveDelete((File)extractDir);
            }
        }
        return null;
    }

    public static String extractGzFile(String filePath, String extractDirName) {
        IPath dirPath = new Path(filePath).removeLastSegments(1);
        String filename = new Path(filePath).lastSegment();
        if (filePath.endsWith(".gz")) {
            File extractDir = dirPath.append(extractDirName).toFile();
            if (!extractDir.exists()) {
                FileUtil.createDirectory((File)extractDir);
            } else {
                FileUtil.recursiveDelete((File)extractDir);
                FileUtil.createDirectory((File)extractDir);
            }
            try {
                String destPath = new Path(extractDir.getAbsolutePath()).append(filename).toOSString();
                FileUtil.copyTo((String)filePath, (String)destPath);
                String command = String.format("gzip -d \"%s\"", destPath);
                if (HostUtil.execute(command, extractDir.getAbsolutePath())) {
                    return extractDir.getAbsolutePath();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtil.recursiveDelete((File)extractDir);
            }
        }
        return null;
    }

    public static class ExtFilter
    implements FilenameFilter {
        protected String ext;

        public ExtFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

