/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.tizen.nativecommon.launch.TizenDeviceProcessList;
import org.tizen.sdblib.IDevice;

public class ProcessSelector {
    private IDevice device;
    private IProcessInfo procInfo;

    public ProcessSelector(IDevice device) {
        this.device = device;
    }

    public IProcessInfo getProcess(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProcessSelector.this.procInfo = ProcessSelector.this.selectProcess(shell, null);
            }
        });
        return this.procInfo;
    }

    public IProcessInfo getProcess(final Shell shell, final String procName) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProcessSelector.this.procInfo = ProcessSelector.this.selectProcess(shell, procName);
            }
        });
        return this.procInfo;
    }

    private IProcessInfo selectProcess(Shell shell, String procName) {
        if (shell == null) {
            return null;
        }
        TizenDeviceProcessList processList = null;
        processList = new TizenDeviceProcessList(this.device);
        Object[] pInfos = null;
        IProcessInfo resultInfo = null;
        pInfos = processList.getProcessList();
        if (pInfos == null) {
            return null;
        }
        int count = 0;
        if (procName != null) {
            Object[] objectArray = pInfos;
            int n = pInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessInfo info = objectArray[n2];
                String name = new Path(info.getName()).lastSegment().trim();
                if (procName.equals(name)) {
                    resultInfo = info;
                    ++count;
                }
                ++n2;
            }
        }
        if (count == 1) {
            return resultInfo;
        }
        LabelProvider topprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo pinfo = (IProcessInfo)element;
                Path ppath = new Path(pinfo.getName());
                return String.valueOf(ppath.lastSegment().trim()) + " [" + String.valueOf(pinfo.getPid()) + "]";
            }

            public Image getImage(Object element) {
                return LaunchImages.get((String)LaunchImages.IMG_OBJS_EXEC);
            }
        };
        LabelProvider downprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                return info.getName();
            }

            public Image getImage(Object element) {
                return LaunchImages.get((String)LaunchImages.IMG_OBJS_EXEC);
            }
        };
        TwoPaneElementSelector dlg = new TwoPaneElementSelector(shell, (ILabelProvider)topprovider, (ILabelProvider)downprovider);
        dlg.setTitle(String.format("Select Process [%s]", this.device.getDeviceName()));
        String dlgMsg = "";
        if (procName != null && count == 0) {
            dlgMsg = String.format("There is no \"%s\" process.\n", procName);
        } else if (procName != null && count > 1) {
            dlgMsg = String.format("There are some \"%s\" processes.\n", procName);
        }
        dlgMsg = String.valueOf(dlgMsg) + "Select a Process to attach debugger to:";
        dlg.setMessage(dlgMsg);
        dlg.setElements(pInfos);
        if (dlg.open() == 0) {
            resultInfo = (IProcessInfo)dlg.getFirstResult();
            return resultInfo;
        }
        return null;
    }
}

