/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GBSConfFile {
    public static final String GENERAL_SECTION = "[general]";
    public static final String PROFILE_SECTION = "[profile.";
    public static final String OBS_SECTION = "[obs.";
    public static final String REPO_SECTION = "[repo.";
    public GeneralSection generalSection;
    public List<ProfileSection> profileSections = new ArrayList<ProfileSection>();
    public List<OBSSection> obsSections = new ArrayList<OBSSection>();
    public List<RepositorySection> repoSections = new ArrayList<RepositorySection>();

    public void createNewGeneralSection() {
        this.generalSection = new GeneralSection();
    }

    public void setGeneralSectionName(String name) {
        assert (this.generalSection != null);
        this.generalSection.setName(name);
    }

    public void addGeneralConfiguration(String key, String value) {
        assert (this.generalSection != null);
        this.generalSection.addConfiguration(key, value);
    }

    public void createNewProfileSection() {
        this.profileSections.add(new ProfileSection());
    }

    public void setProfileSectionName(String name) {
        this.setSectionName(this.profileSections, name);
    }

    public void addProfileConfiguration(String key, String value) {
        this.addConfiguration(this.profileSections, key, value);
    }

    public void createNewOBSSection() {
        this.obsSections.add(new OBSSection());
    }

    public void setOBSSectionName(String name) {
        this.setSectionName(this.obsSections, name);
    }

    public void addOBSConfiguration(String key, String value) {
        this.addConfiguration(this.obsSections, key, value);
    }

    public void createNewRepoSection() {
        this.repoSections.add(new RepositorySection());
    }

    public void setRepoSectionName(String name) {
        this.setSectionName(this.repoSections, name);
    }

    public void addRepoConfiguration(String key, String value) {
        this.addConfiguration(this.repoSections, key, value);
    }

    public void setSectionName(List<? extends GBSCommonSection> sections, String name) {
        assert (!sections.isEmpty());
        if (name.startsWith("[")) {
            name = name.substring(1);
        }
        if (name.endsWith("]")) {
            name = name.substring(0, name.length() - 1);
        }
        sections.get(sections.size() - 1).setName(name.trim());
    }

    public void addConfiguration(List<? extends GBSCommonSection> sections, String key, String value) {
        assert (!sections.isEmpty());
        sections.get(sections.size() - 1).addConfiguration(key, value);
    }

    public class GBSCommonSection {
        protected String name;
        protected Map<String, String> configuration = new HashMap<String, String>();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguration(String key, String value) {
            this.configuration.put(key, value);
        }

        public String getConfiguration(String key) {
            return this.configuration.get(key);
        }
    }

    public class GeneralSection
    extends GBSCommonSection {
        ProfileSection profileSection;

        public void setProfileSection(ProfileSection section) {
            this.profileSection = section;
        }

        public ProfileSection getProfileSection() {
            return this.profileSection;
        }
    }

    public class OBSSection
    extends GBSCommonSection {
    }

    public class ProfileSection
    extends GBSCommonSection {
        List<RepositorySection> repoSections = new ArrayList<RepositorySection>();

        public void addRepoSection(RepositorySection section) {
            this.repoSections.add(section);
        }

        public List<RepositorySection> getRepoSections() {
            return this.repoSections;
        }
    }

    public class RepositorySection
    extends GBSCommonSection {
    }
}

