/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;

public class RootstrapNameUtil {
    protected static final String REGEX_NAME = "([A-Za-z0-9\\-\\_]+)";

    public static boolean validateRootstrapName(String name) {
        return name.matches(REGEX_NAME);
    }

    public static String getRootstrapNameForRemoteRepo(String[] urls) {
        String name = "";
        String snapshot = "";
        if (urls != null) {
            if (urls.length > 0) {
                String url = urls[0];
                snapshot = new Path(url).lastSegment();
            } else {
                snapshot = "temporary";
            }
            int i = 1;
            while (i < 100) {
                name = String.format("%s_%d", snapshot, i);
                if (!CommonRootstrapManager.existsRootstrap(name)) break;
                ++i;
            }
        }
        return name;
    }

    public static String getRootstrapNameForLocalRepo(String repoPath) {
        String name = "";
        Path path = new Path(repoPath);
        String prefix = path.lastSegment();
        int i = 1;
        while (i < 100) {
            name = String.format("%s_%d", prefix, i);
            if (!CommonRootstrapManager.existsRootstrap(name)) break;
            ++i;
        }
        return name;
    }
}

