/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.pkgmgr.ui.AddRepoDialog;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;
import org.tizen.nativeplatform.preferences.RootstrapPreferencesManager;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.nativeplatform.rootstrap.util.DeviceRepoManager;
import org.tizen.nativeplatform.rootstrap.util.RootstrapNameUtil;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapSettingPage3
extends WizardPage {
    private final String BUNDLE_NAME = String.valueOf(RootstrapSettingPage3.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Shell shell;
    private IOConsoleViewer logViewer;
    private TableViewer repoTable;
    private Combo archCombo;
    private Combo deviceCombo;
    private Text rootstrapText;
    private Button add_bt;
    private Button remove_bt;
    private Button modify_bt;
    private Button moveup_bt;
    private Button movedown_bt;
    private Button generateImmediateBt;
    private Wizard wizard;
    private boolean validateData = false;
    private final String GENERATE_CONSOLE_NAME = "Rootstrap Generation";
    protected final Logger logger = LoggerFactory.getLogger(RootstrapSettingPage3.class);

    public RootstrapSettingPage3(Wizard wizard, String pageName, Shell shell, IProject project, IConfiguration config) {
        super(pageName);
        this.shell = shell;
        this.wizard = wizard;
        this.setTitle(this.resources.getString("RootstrapPage3.Title"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createDeviceComposite(composite);
        Composite subComposite = new Composite(composite, 2048);
        subComposite.setLayout((Layout)new GridLayout(1, false));
        subComposite.setLayoutData((Object)new GridData(1808));
        this.createNameComposite(subComposite);
        this.createArchComposite(subComposite);
        this.createTableComposite(subComposite);
        this.createLogViewer(subComposite);
        this.setControl((Control)subComposite);
        this.setDefaultInput();
    }

    private String[] addDefaultInput(String[] reposTmp) {
        ArrayList<String> rList = new ArrayList<String>();
        ArrayList<String> newList = new ArrayList<String>();
        String[] stringArray = reposTmp;
        int n = reposTmp.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            rList.add(r);
            newList.add(r);
            ++n2;
        }
        for (String s : rList) {
            if (!s.contains("packages")) continue;
            StringBuffer debugUrl = new StringBuffer(s);
            debugUrl.replace(debugUrl.lastIndexOf("packages"), debugUrl.lastIndexOf("packages") + 8, "debug");
            if (newList.contains(debugUrl.toString())) continue;
            newList.add(debugUrl.toString());
        }
        if (this.archCombo.getText().equals("armv7l")) {
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl0Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl1Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl2Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl3Default());
        } else {
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl0Ia32Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl1Ia32Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl2Ia32Default());
            this.addDefaultRootstrapUrl(newList, RootstrapPreferencesManager.getStandardRootstrapUrl3Ia32Default());
        }
        String[] resultRepos = newList.toArray(new String[newList.size()]);
        return resultRepos;
    }

    private void addDefaultRootstrapUrl(List<String> list, String defaultValue) {
        if (!defaultValue.equals("")) {
            list.add(defaultValue);
        }
    }

    private void setDefaultInput() {
        this.deviceCombo.setItems(DeviceRepoManager.getDeviceNames());
        this.deviceCombo.select(0);
        this.archCombo.setItems(DeviceRepoManager.getArchs(this.deviceCombo.getText()));
        this.archCombo.select(0);
        String[] reposTmp = DeviceRepoManager.getRepos(this.deviceCombo.getText(), this.archCombo.getText());
        String[] repos = this.addDefaultInput(reposTmp);
        this.updateData(repos);
    }

    private void createNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label lName = new Label(composite, 0);
        lName.setText(this.resources.getString("RootstrapPage3.Name"));
        this.rootstrapText = new Text(composite, 2052);
        this.rootstrapText.setLayoutData((Object)gridData);
        this.rootstrapText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RootstrapWizardData.setRootstrapName(RootstrapSettingPage3.this.rootstrapText.getText());
                RootstrapSettingPage3.this.validPageComplete();
            }
        });
    }

    private void createDeviceComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label deviceLabel = new Label(composite, 16);
        deviceLabel.setText(this.resources.getString("RootstrapPage3.Device"));
        this.deviceCombo = new Combo(composite, 8);
        this.deviceCombo.setLayoutData((Object)gridData);
        this.deviceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String device = ((Combo)e.getSource()).getText();
                RootstrapSettingPage3.this.archCombo.setItems(DeviceRepoManager.getArchs(device));
                RootstrapSettingPage3.this.archCombo.select(0);
                String[] reposTmp = DeviceRepoManager.getRepos(device, RootstrapSettingPage3.this.archCombo.getText());
                String[] repos = RootstrapSettingPage3.this.addDefaultInput(reposTmp);
                RootstrapSettingPage3.this.updateData(repos);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createArchComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label archLabel = new Label(composite, 16);
        archLabel.setText(this.resources.getString("RootstrapPage.Label.Arch"));
        this.archCombo = new Combo(composite, 8);
        this.archCombo.setLayoutData((Object)gridData);
        this.archCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String device = RootstrapSettingPage3.this.deviceCombo.getText();
                String arch = ((Combo)e.getSource()).getText();
                String[] reposTmp = DeviceRepoManager.getRepos(device, arch);
                String[] repos = RootstrapSettingPage3.this.addDefaultInput(reposTmp);
                RootstrapSettingPage3.this.updateData(repos);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.generateImmediateBt = new Button(composite, 32);
        this.generateImmediateBt.setText(this.resources.getString("RootstrapPage.Label.GenImmediately"));
        this.generateImmediateBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RootstrapWizardData.setGenImmediately(RootstrapSettingPage3.this.generateImmediateBt.getSelection());
            }
        });
        this.generateImmediateBt.setSelection(false);
    }

    private void createLogViewer(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new FillLayout());
        RootstrapWizardData.setConsoleMgr(new ConsoleManager("Rootstrap Generation", false));
        RootstrapWizardData.getConsoleMgr().clear();
        MessageConsoleStream mcs = RootstrapWizardData.getConsoleMgr().getMessageConsoleStream();
        this.logViewer = new IOConsoleViewer(composite, (TextConsole)mcs.getConsole());
        int line = this.logViewer.getTextWidget().getLineCount();
        if (line > 0) {
            this.logViewer.getTextWidget().setTopIndex(line);
        }
        IOUtil.tryClose((Object[])new Object[]{mcs});
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        composite.setLayoutData((Object)gridData);
        this.createRepositoryTable(composite);
        this.createRepositoryButtons(composite);
    }

    private void createRepositoryTable(Composite parent) {
        Composite t_composite = new Composite(parent, 0);
        t_composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        t_composite.setLayout((Layout)layout);
        this.repoTable = new TableViewer(t_composite, 2304);
        Table table = this.repoTable.getTable();
        GridData tableGridData = new GridData(1808);
        table.setLayoutData((Object)tableGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Repositories"};
        int[] columnWidths = new int[]{1000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ++i;
        }
        this.repoTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createRepositoryButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createAddButton(composite);
        this.createRemoveButton(composite);
        this.createModifyButton(composite);
        this.createMoveupButton(composite);
        this.createMovedownButton(composite);
    }

    private void createAddButton(Composite parent) {
        this.add_bt = new Button(parent, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        this.add_bt.setImage(addIcon);
        this.add_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AddRepoDialog dialog = new AddRepoDialog(RootstrapSettingPage3.this.shell, "Rootstrap", false);
                if (dialog.open() != 0) {
                    return;
                }
                String url = dialog.getRepositoryURL();
                RootstrapSettingPage3.this.addRepository(url);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createRemoveButton(Composite parent) {
        this.remove_bt = new Button(parent, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        this.remove_bt.setImage(removeIcon);
        this.remove_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage3.this.repoTable.getTable().getSelectionIndex();
                RootstrapSettingPage3.this.removeRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createModifyButton(Composite parent) {
        this.modify_bt = new Button(parent, 8);
        Image modifyIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/edit.gif");
        this.modify_bt.setImage(modifyIcon);
        this.modify_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage3.this.repoTable.getTable().getSelectionIndex();
                String repo = (String)RootstrapSettingPage3.this.repoTable.getTable().getItem(selectedIdx).getData();
                String name = "repository";
                ModifyRepoDialog dialog = new ModifyRepoDialog(RootstrapSettingPage3.this.shell, "Rootstrap", name, repo, false);
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.isDirty()) {
                    String newUrl = dialog.getRepositoryURL();
                    RootstrapSettingPage3.this.modifyRepository(selectedIdx, newUrl);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createMoveupButton(Composite parent) {
        this.moveup_bt = new Button(parent, 8);
        Image moveupIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-moveup.gif");
        this.moveup_bt.setImage(moveupIcon);
        this.moveup_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage3.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx < 1) {
                    return;
                }
                RootstrapSettingPage3.this.moveUpRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createMovedownButton(Composite parent) {
        this.movedown_bt = new Button(parent, 8);
        Image movedownIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-movedown.gif");
        this.movedown_bt.setImage(movedownIcon);
        this.movedown_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int size = ((List)RootstrapSettingPage3.this.repoTable.getInput()).size();
                int selectedIdx = RootstrapSettingPage3.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx >= size - 1) {
                    return;
                }
                RootstrapSettingPage3.this.moveDownRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void addRepository(String newRepo) {
        List repos = (List)this.repoTable.getInput();
        repos.add(newRepo);
        this.updateData(repos);
    }

    private void moveUpRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index - 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index - 1);
        repos.add(index - 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.updateData(repos);
        this.repoTable.getTable().setSelection(index - 1);
    }

    private void moveDownRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index + 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index + 1);
        repos.add(index + 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.updateData(repos);
        this.repoTable.getTable().setSelection(index + 1);
    }

    private void modifyRepository(int index, String newRepo) {
        List repos = (List)this.repoTable.getInput();
        repos.remove(index);
        repos.add(index, newRepo);
        this.updateData(repos);
    }

    private void removeRepository(int index) {
        String data = (String)this.repoTable.getTable().getItem(index).getData();
        List repos = (List)this.repoTable.getInput();
        ArrayList<String> newRepos = new ArrayList<String>();
        for (String repo : repos) {
            if (repo.equals(data)) continue;
            newRepos.add(repo);
        }
        this.updateData(newRepos);
    }

    private void updateData(String[] repos) {
        this.updateData(new ArrayList<String>(Arrays.asList(repos)));
    }

    private void updateData(List<String> repos) {
        RootstrapWizardData.setRootstrapName(this.rootstrapText.getText());
        RootstrapWizardData.setRootstrapArch(this.archCombo.getText());
        RootstrapWizardData.getRepositories().clear();
        RootstrapWizardData.addRepositories(repos);
        this.repoTable.setInput(repos);
        this.validPageComplete();
    }

    private void setDefaultMessage() {
        int repoSize = RootstrapWizardData.getRepositories().size();
        this.setMessage(String.format(this.resources.getString("RtPage.Msg.GetRepo"), repoSize));
    }

    public boolean validateRootstrapName() {
        String rootstrapName = this.rootstrapText.getText();
        if (rootstrapName == null || rootstrapName.isEmpty()) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage.Error.RootstrapNameIsEmpty"));
            return false;
        }
        if (!RootstrapNameUtil.validateRootstrapName(rootstrapName)) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage.Error.RootstrapName"));
            return false;
        }
        if (CommonRootstrapManager.existsRootstrap(rootstrapName)) {
            this.pageNotCompleted(String.format(this.resources.getString("RootstrapPage.Error.ExistsRootstrap"), rootstrapName));
            return false;
        }
        return true;
    }

    public boolean validateArchitecture() {
        String arch = this.archCombo.getText();
        if (arch == null || arch.isEmpty()) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage.Error.ArchIsEmpty"));
            return false;
        }
        return true;
    }

    public boolean validateRepositories() {
        int repoSize = RootstrapWizardData.getRepositories().size();
        int tableCount = this.repoTable.getTable().getItemCount();
        if (tableCount > 0 && repoSize == tableCount) {
            return true;
        }
        this.pageNotCompleted(this.resources.getString("RtPage.ErrorMsg.FailedGetRepo"));
        return false;
    }

    public boolean canFinish() {
        return this.validateData;
    }

    private void validPageComplete() {
        if (!(this.validateRootstrapName() && this.validateArchitecture() && this.validateRepositories())) {
            return;
        }
        this.pageCompleted();
    }

    private void pageNotCompleted(String errorMsg) {
        this.validateData = false;
        this.setErrorMessage(errorMsg);
        this.setPageComplete(false);
    }

    private void pageCompleted() {
        this.validateData = true;
        this.setErrorMessage(null);
        this.setDefaultMessage();
        this.setPageComplete(true);
    }
}

