/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.nativeplatform.model.Architecture;

public class RootstrapWizardData {
    private static boolean supportLocalRepo;
    private static boolean remoteRepoEnabled;
    private static boolean genImmediately;
    private static String localrepoPath;
    private static String confFilePath;
    private static String rootstrapName;
    private static String rootstrapArch;
    private static String defaultProfile;
    private static List<String> snapshots;
    private static List<String> repositories;
    private static List<String> archStrings;
    private static List<Architecture> architectures;
    private static ConsoleManager consoleMgr;
    private static Map<String, List<String>> profileMap;

    static {
        snapshots = new ArrayList<String>();
        repositories = new ArrayList<String>();
        archStrings = new ArrayList<String>();
        architectures = new ArrayList<Architecture>();
    }

    public static void clearData() {
        supportLocalRepo = false;
        rootstrapName = "";
        rootstrapArch = "";
        localrepoPath = "";
        confFilePath = "";
        snapshots.clear();
        repositories.clear();
        architectures.clear();
        archStrings.clear();
        remoteRepoEnabled = true;
        genImmediately = false;
        consoleMgr = null;
        profileMap = null;
        defaultProfile = null;
    }

    public static void setDefaultProfile(String profile) {
        defaultProfile = profile;
    }

    public static String getDefaulatProfile() {
        return defaultProfile;
    }

    public static boolean isSupportLocalRepo() {
        return supportLocalRepo;
    }

    public static void setSupportLocalRepo(boolean supportLocalRepo) {
        RootstrapWizardData.supportLocalRepo = supportLocalRepo;
    }

    public static boolean isRemoteRepoEnabled() {
        return remoteRepoEnabled;
    }

    public static void setRemoteRepoEnabled(boolean remoteRepoEnabled) {
        RootstrapWizardData.remoteRepoEnabled = remoteRepoEnabled;
    }

    public static String getRootstrapName() {
        return rootstrapName;
    }

    public static void setRootstrapName(String rootstrapName) {
        RootstrapWizardData.rootstrapName = rootstrapName;
    }

    public static String getRootstrapArch() {
        return rootstrapArch;
    }

    public static void setRootstrapArch(String rootstrapArch) {
        RootstrapWizardData.rootstrapArch = rootstrapArch;
    }

    public static void clearSnapshots() {
        snapshots.clear();
    }

    public static List<String> getSnapshots() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : snapshots) {
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }

    public static void setSnapshot(String snapshot, int index) {
        if (snapshots.size() >= index + 1) {
            snapshots.set(index, snapshot);
        } else {
            snapshots.add(index, snapshot);
        }
    }

    public static void addSnapshot(String snapshot) {
        snapshots.add(snapshot);
    }

    public static List<String> getRepositories() {
        return repositories;
    }

    public static void addRepositories(List<String> repos) {
        repositories.addAll(repos);
    }

    public static List<String> getArchStrings() {
        return archStrings;
    }

    public static void addArchString(String arch) {
        archStrings.add(arch);
    }

    public static List<Architecture> getArchitectures() {
        return architectures;
    }

    public static void addArchitectures(List<Architecture> architectures) {
        RootstrapWizardData.architectures.addAll(architectures);
    }

    public static boolean isGenImmediately() {
        return genImmediately;
    }

    public static void setGenImmediately(boolean genImmediately) {
        RootstrapWizardData.genImmediately = genImmediately;
    }

    public static String getLocalrepoPath() {
        return localrepoPath;
    }

    public static void setLocalrepoPath(String localrepoPath) {
        RootstrapWizardData.localrepoPath = localrepoPath;
    }

    public static String getConfFilePath() {
        return confFilePath;
    }

    public static void setConfFilePath(String confFilePath) {
        RootstrapWizardData.confFilePath = confFilePath;
    }

    public static ConsoleManager getConsoleMgr() {
        return consoleMgr;
    }

    public static void setConsoleMgr(ConsoleManager consoleMgr) {
        RootstrapWizardData.consoleMgr = consoleMgr;
    }

    public static Map<String, List<String>> getSnapshotMap() {
        return profileMap;
    }

    public static void setProfileMap(Map<String, List<String>> profileMap) {
        RootstrapWizardData.profileMap = profileMap;
    }

    public static boolean validate() {
        if (rootstrapName == null || rootstrapName.isEmpty()) {
            return false;
        }
        if (rootstrapArch == null || rootstrapArch.isEmpty()) {
            return false;
        }
        if (repositories.isEmpty()) {
            return false;
        }
        if (!remoteRepoEnabled) {
            if (localrepoPath == null || localrepoPath.isEmpty()) {
                return false;
            }
            if (confFilePath == null || confFilePath.isEmpty()) {
                return false;
            }
        }
        return true;
    }
}

