/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.coredump;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.PlatformDirUtil;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.SyncResult;

public class CoredumpSelectionHandler {
    private PkgCommandTarget target;
    private final Logger logger = LoggerFactory.getLogger(CoredumpSelectionHandler.class);

    public CoredumpSelectionHandler(PkgCommandTarget target) {
        this.target = target;
    }

    public String processRemoteCorefile(FileEntry entry, IProgressMonitor monitor) throws CoreException, Exception {
        return this.processRemoteFile(entry, null, monitor);
    }

    public String processRemoteCsfile(FileEntry entry, IProgressMonitor monitor) throws CoreException, Exception {
        return this.processRemoteFile(entry, null, monitor);
    }

    public String processRemoteFile(FileEntry entry, String ext, IProgressMonitor monitor) throws CoreException, Exception {
        monitor.beginTask("", 1);
        monitor.subTask(String.format("Downloading %s file...", entry.getFullPath()));
        try {
            String workingDir = PlatformDirUtil.getCoredumpDir();
            FileUtil.createDirectory((String)workingDir);
            String path = entry.getFullPath();
            String fileName = new Path(path).lastSegment();
            String destFilePrefix = new Path(workingDir).append(fileName).toOSString();
            String string = this.downloadFile(entry, destFilePrefix, ext);
            return string;
        }
        finally {
            monitor.done();
        }
    }

    private String downloadFile(FileEntry entry, String destFilePrefix, String ext) throws CoreException, Exception {
        ArrayList<String> downloadedFiles = new ArrayList<String>();
        if (entry == null) {
            return null;
        }
        if (ext == null || ext.equals(FilenameUtil.getExtension((String)entry.getName()))) {
            String selectedFilePath = entry.getFullPath();
            FileEntry file = this.target.getDevice().getFileEntry(selectedFilePath);
            FileOutputStream fileOut = null;
            try {
                String outputPath = destFilePrefix;
                fileOut = new FileOutputStream(outputPath);
                SyncResult result = this.target.getDevice().getSyncService().doPull(file, (OutputStream)fileOut, null, -1);
                if (result.isOk()) {
                    downloadedFiles.add(outputPath);
                } else {
                    this.logger.error(String.format("Failed to pull file: %s", selectedFilePath));
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{fileOut});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{fileOut});
        }
        if (downloadedFiles.isEmpty()) {
            return null;
        }
        return (String)downloadedFiles.get(0);
    }
}

