/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.rpm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.factory.PkgStatusUpdaterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgLauncher;
import org.tizen.nativeplatform.launcher.rpm.IPkgStatusUpdater;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.preferences.DevicePreferencesManager;
import org.tizen.nativeplatform.rds.IRpmRapidDeployer;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.LaunchTypes;
import org.tizen.nativeplatform.types.PkgInstallTypes;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.LRCaching;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.DeviceUtil;

public class RpmPackageLauncher
implements IPkgLauncher {
    protected IProject project;
    protected PkgCommandTarget target;
    protected IPkgStatusUpdater pkgUpdater;
    protected IPackageUtil pkgUtil;
    protected boolean reinstallOp;
    protected List<IPackage> devicePackages;
    protected List<IPackage> rootstrapPackages;
    protected String[] appids;
    protected String deviceLog = "";
    protected String rootstrapLog = "";
    protected final Logger logger = LoggerFactory.getLogger(RpmPackageLauncher.class);

    public RpmPackageLauncher(IProject project, PkgCommandTarget target, List<IPackage> devicePackages, List<IPackage> rootstrapPackages, boolean reinstallOp) {
        this.devicePackages = devicePackages;
        this.rootstrapPackages = rootstrapPackages;
        this.reinstallOp = reinstallOp;
        this.project = project;
        this.target = target;
        this.pkgUpdater = PkgStatusUpdaterFactory.getUpdater(target);
        this.pkgUtil = PlatformInstances.getPackageUtil();
    }

    @Override
    public void debugLaunchPkgs(LaunchTypes type, Shell shell, IProgressMonitor monitor) throws InterruptedException {
        this.validateRootstrap(this.target.getRootstrap().getId());
        ArrayList<PkgStatus> buildSystemPkgStatus = new ArrayList<PkgStatus>();
        ArrayList<PkgStatus> devicePkgStatus = new ArrayList<PkgStatus>();
        monitor.beginTask("", 2);
        monitor.subTask(PlatformLaunchMessages.UPDATE_PKG_INFOS);
        buildSystemPkgStatus.addAll(this.filterAndUpdatePkgs(CmdTargetTypes.ROOTSTRAP));
        if (!type.equals((Object)LaunchTypes.ATTACH)) {
            devicePkgStatus.addAll(this.filterAndUpdatePkgs(CmdTargetTypes.DEVICE));
        }
        monitor.worked(1);
        this.internalLaunchPkgs(buildSystemPkgStatus, devicePkgStatus, shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    @Override
    public void launchPkgs(Shell shell, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<PkgStatus> buildSystemPkgStatus = new ArrayList<PkgStatus>();
        ArrayList<PkgStatus> devicePkgStatus = new ArrayList<PkgStatus>();
        monitor.beginTask("", 2);
        devicePkgStatus.addAll(this.filterAndUpdatePkgs(CmdTargetTypes.DEVICE));
        monitor.subTask(PlatformLaunchMessages.UPDATE_PKG_INFOS);
        monitor.worked(1);
        this.internalLaunchPkgs(buildSystemPkgStatus, devicePkgStatus, shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected void setAppids() {
        this.appids = PlatformLaunchUtil.getAppId((IProject)this.project);
    }

    protected boolean checkAvaiableRds(IProject project, List<PkgStatus> pkgStatus) {
        boolean checkedRdsPref = RdsPreferencePage.isRdsMode((IProject)project);
        if (!checkedRdsPref) {
            return false;
        }
        for (PkgStatus status : pkgStatus) {
            if (status.getInstallInfo().equals((Object)PkgInstallTypes.INSTALLED)) continue;
            checkedRdsPref = false;
        }
        return checkedRdsPref;
    }

    protected void internalLaunchPkgs(List<PkgStatus> buildSystemPkgStatus, List<PkgStatus> devicePkgStatus, Shell shell, IProgressMonitor monitor) throws InterruptedException {
        Thread thread;
        UserLogger.start((String)"platform.launch", (String)".install");
        int totalWorks = 1;
        if (!buildSystemPkgStatus.isEmpty()) {
            ++totalWorks;
        }
        if (!devicePkgStatus.isEmpty()) {
            ++totalWorks;
        }
        if (monitor != null) {
            monitor.beginTask("", totalWorks);
        }
        if (monitor != null) {
            monitor.subTask(PlatformLaunchMessages.CHECK_PKG_STATUS);
        }
        boolean isEflApp = CommonPackageUtil.checkXmls((IProject)this.project);
        List<IPackage> selectBsPkgs = this.getSelectedPackages(buildSystemPkgStatus);
        List<IPackage> selectDvPkgs = this.getSelectedPackages(devicePkgStatus);
        boolean bsAvailableRds = false;
        boolean dvAvailableRds = false;
        ArrayList<Thread> installThread = new ArrayList<Thread>();
        if (monitor != null) {
            monitor.worked(1);
        }
        String taskMsg = this.makeInstallPkgTaskMsg(PlatformLaunchMessages.INSTALL_PACKAGES_TO_BUILDSYSTEM, selectBsPkgs);
        if (monitor != null) {
            monitor.subTask(taskMsg);
        }
        if (selectBsPkgs != null && !selectBsPkgs.isEmpty()) {
            thread = new RootstrapInstallThread(selectBsPkgs, bsAvailableRds, monitor);
            installThread.add(thread);
            thread.start();
        }
        taskMsg = this.makeInstallPkgTaskMsg(PlatformLaunchMessages.INSTALL_PACKAGES_TO_DEVICE, selectDvPkgs);
        if (monitor != null) {
            monitor.subTask(taskMsg);
        }
        if (selectDvPkgs != null && !selectDvPkgs.isEmpty()) {
            thread = new DeviceInstallThread(this.project, selectDvPkgs, isEflApp, dvAvailableRds, monitor);
            installThread.add(thread);
            thread.start();
        }
        boolean installResult = false;
        for (Thread t1 : installThread) {
            t1.join();
            if (t1 instanceof DeviceInstallThread) {
                boolean bl = installResult = ((DeviceInstallThread)t1).isInstallResult();
                if (!installResult) {
                    InterruptedException ex = ((DeviceInstallThread)t1).getException();
                    if (ex != null) {
                        throw ((DeviceInstallThread)t1).getException();
                    }
                    throw new InterruptedException(PlatformLaunchMessages.FAILED_INSTALL_PKGS_DEVICE);
                }
            }
            if (t1 instanceof RootstrapInstallThread) {
                boolean bl = installResult = ((RootstrapInstallThread)t1).isInstallResult();
                if (!installResult) {
                    InterruptedException ex = ((RootstrapInstallThread)t1).getException();
                    if (ex != null) {
                        throw ((RootstrapInstallThread)t1).getException();
                    }
                    throw new InterruptedException(PlatformLaunchMessages.FAILED_INSTALL_PKGS_ROOTSTRAP);
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (installResult && !LRCaching.getWorkingCaching().isEmpty()) {
            if (selectBsPkgs != null && !selectBsPkgs.isEmpty()) {
                LRCaching.copyWorkingtoStaging(selectBsPkgs);
            } else {
                LRCaching.copyWorkingtoStaging(selectDvPkgs);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        UserLogger.end((String)"platform.launch", (String)".install");
    }

    protected String makeInstallPkgTaskMsg(String basicMsg, List<IPackage> pkgList) {
        int pkgCount = pkgList.size();
        if (pkgCount == 1) {
            basicMsg = String.valueOf(basicMsg) + ": \"" + pkgList.get(0).getName() + "\"";
        } else if (pkgCount > 1) {
            basicMsg = String.valueOf(basicMsg) + ": \"" + pkgList.get(0).getName() + "\" and " + String.valueOf(pkgCount - 1) + " packages";
        }
        return basicMsg;
    }

    protected List<PkgStatus> filterAndUpdatePkgs(CmdTargetTypes cmdTarget) {
        ArrayList<PkgStatus> pkgStatus = new ArrayList<PkgStatus>();
        if (cmdTarget.equals((Object)CmdTargetTypes.DEVICE)) {
            pkgStatus.addAll(this.pkgUpdater.updateStatus(cmdTarget, this.devicePackages));
        } else if (cmdTarget.equals((Object)CmdTargetTypes.ROOTSTRAP)) {
            pkgStatus.addAll(this.pkgUpdater.updateStatus(cmdTarget, this.rootstrapPackages));
        }
        this.applyReinstallOp(pkgStatus, this.reinstallOp);
        return pkgStatus;
    }

    protected void applyReinstallOp(List<PkgStatus> list, boolean reinstallOp) {
        for (PkgStatus status : list) {
            if (!status.getInstallInfo().equals((Object)PkgInstallTypes.INSTALLED) || reinstallOp) continue;
            status.setChecked(false);
        }
    }

    protected void validateRootstrap(String rootstrapId) throws InterruptedException {
        if (!RootstrapProxy.getProxy().checkInitialized(rootstrapId)) {
            String msg = String.format(PlatformLaunchMessages.IS_NOT_INITIALIZED_ROOTSTRAP, rootstrapId);
            this.newInterruptedException(msg);
        }
    }

    protected void newInterruptedException(String message) throws InterruptedException {
        throw new InterruptedException(message);
    }

    protected List<IPackage> getSelectedPackages(List<PkgStatus> pkgStatus) {
        ArrayList<IPackage> selectedPkgs = new ArrayList<IPackage>();
        for (PkgStatus status : pkgStatus) {
            if (!status.isChecked()) continue;
            selectedPkgs.add(status.getPackage());
        }
        return selectedPkgs;
    }

    protected boolean installPkgsToRootstrap(List<IPackage> packages, IPkgCommander.TOOL type, IProgressMonitor monitor, boolean useRds) throws InterruptedException {
        if (!this.target.getRootstrap().checkInitialized()) {
            this.newInterruptedException(String.format(PlatformLaunchMessages.IS_NOT_INITIALIZED_ROOTSTRAP, this.target.getRootstrap().getId()));
        }
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.ROOTSTRAP);
        boolean installResult = false;
        if (useRds) {
            installResult = this.internalProcessRDS(commander, packages, false, monitor);
            if (!installResult) {
                installResult = this.installPkgs(commander, packages, false, monitor);
            }
        } else {
            installResult = this.installPkgs(commander, packages, false, monitor);
        }
        this.rootstrapLog = commander.getLogs();
        return installResult;
    }

    protected boolean installPkgsToDevice(List<IPackage> packages, boolean isEfl, IProgressMonitor monitor, boolean useRds) throws InterruptedException {
        IDevice device = this.target.getDevice();
        boolean rootStatus = device.isRoot();
        try {
            if (!DeviceUtil.isOnline((IDevice)device)) {
                this.newInterruptedException(TizenLaunchMessages.CANNOT_CONNECT_TO_DEVICE);
            } else if (!PlatformLaunchUtil.checkAndSetDeviceRootOn((IDevice)device)) {
                this.newInterruptedException(PlatformLaunchMessages.DEVICE_IS_NOT_ROOT_ON);
            }
            IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
            boolean installResult = false;
            if (useRds) {
                installResult = this.internalProcessRDS(commander, packages, true, monitor);
                if (!installResult) {
                    installResult = this.internalInstallPkgsToDevice(commander, packages, monitor);
                }
            } else {
                installResult = this.internalInstallPkgsToDevice(commander, packages, monitor);
            }
            this.deviceLog = commander.getLogs();
            boolean bl = installResult;
            return bl;
        }
        finally {
            if (!rootStatus && !PlatformLaunchUtil.checkAndSetDeviceRootOff((IDevice)this.target.getDevice())) {
                this.newInterruptedException(PlatformLaunchMessages.DEVICE_IS_NOT_ROOT_OFF);
            }
        }
    }

    protected boolean internalInstallPkgsToDevice(IPkgCommander commander, List<IPackage> packages, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<String> paths = new ArrayList<String>();
        StringBuffer sbLog = new StringBuffer();
        boolean useSDB = DevicePreferencesManager.isTransferToolSDB();
        if (useSDB) {
            IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)this.project);
            IPath configPath = this.project.getLocation().append(config.getName());
            for (IPackage p : packages) {
                List value;
                String tool = p.getTool();
                String filePath = p.getPath();
                String filename = FileUtil.getFileNameFromPath((String)filePath);
                String targetPath = configPath.append(filename).toOSString();
                ICommandStatus status = commander.installLocalPkg(targetPath.trim(), tool, monitor);
                if (status == null) {
                    this.newInterruptedException(PlatformLaunchMessages.FAILED_INSTALL_PKGS);
                }
                if (!status.isOk()) {
                    this.newInterruptedException(status.getMessage());
                }
                if ((value = status.getValues()) == null || value.isEmpty()) continue;
                for (String s : value) {
                    sbLog.append(String.valueOf(s) + this.newline());
                }
            }
        } else {
            for (IPackage p : packages) {
                List value;
                String tool = p.getTool();
                String filePath = p.getPath();
                paths.add(filePath.trim());
                ICommandStatus status = commander.installLocalPkg(filePath.trim(), tool, monitor);
                if (status == null) {
                    this.newInterruptedException(PlatformLaunchMessages.FAILED_INSTALL_PKGS);
                }
                if (!status.isOk()) {
                    this.newInterruptedException(status.getMessage());
                }
                if ((value = status.getValues()) == null || value.isEmpty()) continue;
                for (String s : value) {
                    sbLog.append(String.valueOf(s) + this.newline());
                }
            }
        }
        return true;
    }

    protected boolean installPkgs(IPkgCommander commander, List<IPackage> packages, boolean isEfl, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<String> paths = new ArrayList<String>();
        boolean useSDB = DevicePreferencesManager.isTransferToolSDB();
        if (useSDB && commander.getCommandType().equals((Object)CmdTargetTypes.DEVICE)) {
            IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)this.project);
            IPath configPath = this.project.getLocation().append(config.getName());
            for (IPackage p : packages) {
                String filePath = p.getPath();
                String filename = FileUtil.getFileNameFromPath((String)filePath);
                String targetPath = configPath.append(filename).toOSString();
                paths.add(targetPath.trim());
            }
        } else {
            for (IPackage p : packages) {
                String filePath = p.getPath();
                paths.add(filePath.trim());
            }
        }
        ICommandStatus status = commander.installLocalPkg(paths.toArray(new String[0]), isEfl, monitor);
        if (status == null) {
            this.newInterruptedException(PlatformLaunchMessages.FAILED_INSTALL_PKGS);
        }
        if (!status.isOk()) {
            this.newInterruptedException(status.getMessage());
        }
        List value = status.getValues();
        StringBuffer sbLog = new StringBuffer();
        if (value != null && !value.isEmpty()) {
            for (String s : value) {
                sbLog.append(String.valueOf(s) + this.newline());
            }
        }
        return true;
    }

    protected boolean internalProcessRDS(IPkgCommander commander, List<IPackage> packages, boolean worksSmack, IProgressMonitor monitor) {
        boolean result = false;
        UserLogger.start((String)"platform.launch", (String)"launch.rds");
        IRpmRapidDeployer rpmRds = LauncherInstances.getLaunchCommandUtil().getRpmRapidDeployer(this.project, commander, packages);
        result = rpmRds.processFast();
        UserLogger.end((String)"platform.launch", (String)"launch.rds");
        return result;
    }

    protected String newline() {
        return "\n";
    }

    @Override
    public String getRootstrapLog() {
        return this.rootstrapLog;
    }

    @Override
    public String getDeviceLog() {
        return this.deviceLog;
    }

    private class DeviceInstallThread
    extends Thread {
        private IProject project = null;
        private List<IPackage> pkgs = null;
        private boolean useRds = false;
        private boolean isEfl = false;
        private boolean isInstallResult = false;
        private IProgressMonitor monitor;
        private InterruptedException exception = null;

        public DeviceInstallThread(IProject project, List<IPackage> pkgs, boolean isEfl, boolean useRds, IProgressMonitor monitor) {
            this.pkgs = pkgs;
            this.project = project;
            this.useRds = useRds;
            this.isEfl = isEfl;
            this.monitor = monitor;
        }

        @Override
        public void run() {
            UserLogger.start((String)"platform.launch", (String)"install.device");
            boolean insPkgs = false;
            try {
                if (this.isEfl) {
                    RpmPackageLauncher.this.setAppids();
                    List<List<IPackage>> result = this.separateAppsAndOthers(this.pkgs);
                    if (result != null) {
                        List<IPackage> apps = result.get(0);
                        List<IPackage> others = result.get(1);
                        if (!apps.isEmpty()) {
                            insPkgs = RpmPackageLauncher.this.installPkgsToDevice(apps, this.isEfl, this.monitor, this.useRds);
                        }
                        if (!others.isEmpty()) {
                            insPkgs = RpmPackageLauncher.this.installPkgsToDevice(others, !this.isEfl, this.monitor, this.useRds);
                        }
                    } else {
                        insPkgs = RpmPackageLauncher.this.installPkgsToDevice(this.pkgs, this.isEfl, this.monitor, this.useRds);
                    }
                } else {
                    insPkgs = RpmPackageLauncher.this.installPkgsToDevice(this.pkgs, this.isEfl, this.monitor, this.useRds);
                }
                if (insPkgs) {
                    this.isInstallResult = true;
                }
            }
            catch (InterruptedException e) {
                this.isInstallResult = false;
                this.exception = e;
            }
            UserLogger.end((String)"platform.launch", (String)"install.device");
        }

        private List<List<IPackage>> separateAppsAndOthers(List<IPackage> pkgs) {
            if (RpmPackageLauncher.this.appids == null) {
                return null;
            }
            ArrayList<List<IPackage>> result = new ArrayList<List<IPackage>>();
            ArrayList<IPackage> apps = new ArrayList<IPackage>();
            ArrayList<IPackage> others = new ArrayList<IPackage>();
            for (IPackage pkg : pkgs) {
                if (CommonPackageUtil.isAppPkg((IProject)this.project, (IPackage)pkg)) {
                    apps.add(pkg);
                    continue;
                }
                others.add(pkg);
            }
            result.add(apps);
            result.add(others);
            return result;
        }

        private boolean isInstallResult() {
            return this.isInstallResult;
        }

        private InterruptedException getException() {
            return this.exception;
        }
    }

    private class RootstrapInstallThread
    extends Thread {
        private List<IPackage> pkgs = null;
        private boolean useRds = false;
        private boolean isInstallResult = false;
        private IProgressMonitor monitor;
        private InterruptedException exception = null;

        public RootstrapInstallThread(List<IPackage> pkgs, boolean useRds, IProgressMonitor monitor) {
            this.pkgs = pkgs;
            this.useRds = useRds;
            this.monitor = monitor;
        }

        @Override
        public void run() {
            UserLogger.start((String)"platform.launch", (String)"install.rootstrap");
            boolean insPkgs = false;
            try {
                insPkgs = RpmPackageLauncher.this.installPkgsToRootstrap(this.pkgs, IPkgCommander.TOOL.ZYPPER, this.monitor, this.useRds);
            }
            catch (InterruptedException e) {
                this.isInstallResult = false;
                this.exception = e;
            }
            if (insPkgs) {
                this.isInstallResult = true;
            }
            UserLogger.end((String)"platform.launch", (String)"install.rootstrap");
        }

        private boolean isInstallResult() {
            return this.isInstallResult;
        }

        private InterruptedException getException() {
            return this.exception;
        }
    }
}

