/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui.shortcut;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.service.FileEntry;

public class TizenPathInputDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private Button okButton;
    private Text text;
    private static final String REMOTE_BROWSE = "Remote Browse...";
    private static final String SELECT_AN_APPLICATION = "Select an Application";

    public TizenPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        Composite pathComp = new Composite(composite, 0);
        GridLayout pathLayout = new GridLayout();
        pathLayout.numColumns = 2;
        pathComp.setLayout((Layout)pathLayout);
        this.text = new Text(pathComp, this.getInputTextStyle());
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.text.setLayoutData((Object)data);
        Button browseButton = TizenPathInputDialog.createPushButton(pathComp, REMOTE_BROWSE, null);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = TizenPathInputDialog.this.handleBrowseButtonSelected();
                if (path != null) {
                    TizenPathInputDialog.this.text.setText(path);
                }
            }
        });
        TizenPathInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        return button;
    }

    protected String handleBrowseButtonSelected() {
        Shell shell = this.getAvailableShell();
        FileEntry path = PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)SELECT_AN_APPLICATION);
        if (path != null) {
            return path.getFullPath();
        }
        return null;
    }

    protected Shell getAvailableShell() {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = PlatformLaunchUtil.getAvaiableShell();
        }
        return shell;
    }
}

