/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.wizard.pages.ApplicationPathDialog;
import org.tizen.nativeplatform.launcher.wizard.pages.CoredumpPackageTableSelectionAdapter;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingRootstrapPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCoredumpLaunchWizard;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.pkgmgr.ui.RPMPackageDialog;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.PkgInstallTypes;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformLaunchSettingDepPkgPage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingDepPkgPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private PlatformCoredumpLaunchWizard wizard = null;
    private TableViewer packageTable;
    private List<String[]> requiredPkgInfo;
    private IPkgCommander commander;
    protected final Logger logger = LoggerFactory.getLogger(PlatformLaunchSettingRootstrapPage.class);

    public PlatformLaunchSettingDepPkgPage(PlatformCoredumpLaunchWizard wizard, String pageName, Shell shell, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName, shell, project, config, target);
        this.wizard = wizard;
        this.setTitle(this.resources.getString("PkgPage.Title"));
        this.setDescription(this.resources.getString("PkgPage.Desc"));
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        this.createPackageManagerComposite(composite);
        this.createTableTitleComposite(composite);
        this.createTableComposite(composite);
        this.createForceEnableFinish(composite);
        this.setControl((Control)composite);
    }

    public void updateData() {
        this.requiredPkgInfo = this.wizard.getRequiredPkgsInfo();
        this.packageTable.setInput(this.requiredPkgInfo);
        this.setEnableFinish(false);
    }

    private void createPackageManagerComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Button binaryPathBt = new Button(composite, 0);
        binaryPathBt.setText(this.resources.getString("PkgPage.Button.binaryPath"));
        binaryPathBt.setLayoutData((Object)gridData);
        binaryPathBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String path;
                String programPath = PlatformLaunchSettingDepPkgPage.this.wizard.getProgramPath();
                ApplicationPathDialog dlg = new ApplicationPathDialog(PlatformLaunchSettingDepPkgPage.this.shell, programPath);
                if (dlg.open() == 0 && (path = dlg.getApplicationPath()) != null && !path.isEmpty()) {
                    PlatformLaunchSettingDepPkgPage.this.wizard.setNewProgramPath(path);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button csBt = new Button(composite, 0);
        csBt.setText(this.resources.getString("PkgPage.Button.Csfile"));
        csBt.setLayoutData((Object)gridData);
        csBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String content = PlatformLaunchSettingDepPkgPage.this.wizard.getCsFileContent();
                PlatformLaunchSettingDepPkgPage.this.wizard.openLogDialog(".cs file content", content);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button logBt = new Button(composite, 0);
        logBt.setText(this.resources.getString("PkgPage.Button.Log"));
        logBt.setLayoutData((Object)gridData);
        logBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String log = PlatformLaunchSettingDepPkgPage.this.wizard.getInstallLog();
                PlatformLaunchSettingDepPkgPage.this.wizard.openLogDialog("Package install log", log);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button pkgMgrBt = new Button(composite, 0);
        pkgMgrBt.setText(this.resources.getString("PkgPage.Button.PkgMgr"));
        pkgMgrBt.setLayoutData((Object)gridData);
        pkgMgrBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PlatformLaunchSettingDepPkgPage.this.handleClickPackageManager();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createTableTitleComposite(Composite parent) {
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(this.resources.getString("PkgPage.Label.RequiredPkg"));
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 340;
        composite.setLayoutData((Object)gridData);
        Composite t_composite = new Composite(composite, 0);
        t_composite.setLayout((Layout)new FillLayout());
        t_composite.setLayoutData((Object)new GridData(1808));
        this.packageTable = new TableViewer(t_composite, 2816);
        Table table = this.packageTable.getTable();
        this.createPackageTableColumns(t_composite);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.packageTable.setLabelProvider((IBaseLabelProvider)new RequiredPkgTableViewerProvider());
        this.packageTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createForceEnableFinish(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Button enableBt = new Button(composite, 32);
        enableBt.setText("Enable finish button by force");
        enableBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PlatformLaunchSettingDepPkgPage.this.setEnableFinish(true);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createPackageTableColumns(Composite parent) {
        String[] titles = new String[]{"Package Name", "Version", "Status"};
        int[] bounds = new int[]{250, 200, 130};
        CoredumpPackageTableSelectionAdapter adapter = new CoredumpPackageTableSelectionAdapter(this.packageTable);
        TableViewerColumn colPackage = this.createTableViewerColumn(this.packageTable, adapter, titles[0], bounds[0], 0);
        colPackage.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String[] info = (String[])element;
                return info[0];
            }
        });
        TableViewerColumn colInsVer = this.createTableViewerColumn(this.packageTable, adapter, titles[1], bounds[1], 0);
        colInsVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String[] info = (String[])element;
                return info[1];
            }
        });
        TableViewerColumn colNewVer = this.createTableViewerColumn(this.packageTable, adapter, titles[2], bounds[2], 0);
        colNewVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String[] info = (String[])element;
                return info[2];
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, SelectionAdapter adapter, String title, int bound, int Style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, Style);
        TableColumn column = viewerColumn.getColumn();
        column.addSelectionListener((SelectionListener)adapter);
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void handleClickPackageManager() {
        IWizardContainer container = this.getContainer();
        final PlatformRootstrap rootstrap = this.wizard.getSelectedRootstrap();
        PkgCommandTarget cmdTarget = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), rootstrap);
        final PkgMgrInitializer initializer = new PkgMgrInitializer(cmdTarget);
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    monitor.subTask("Initializing Package Manager...");
                    try {
                        initializer.fastInitData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            RootstrapProxy.getProxy().winCacheModificationTime(rootstrap);
            RPMPackageDialog dlg = new RPMPackageDialog(this.shell, cmdTarget);
            dlg.open();
            this.commander = cmdTarget.getCommander(CmdTargetTypes.ROOTSTRAP);
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", PlatformLaunchSettingDepPkgPage.this.requiredPkgInfo.size() + 1);
                    monitor.subTask("Checking debug package change...");
                    try {
                        RootstrapProxy.getProxy().winSyncronizeIfChanges(rootstrap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        for (String[] info : PlatformLaunchSettingDepPkgPage.this.requiredPkgInfo) {
                            PlatformLaunchSettingDepPkgPage.this.checkCancelProcess(monitor);
                            String pkg = info[0];
                            monitor.subTask(String.format("Searching %s package", pkg));
                            PkgInstallTypes installInfo = PlatformLaunchSettingDepPkgPage.this.commander.searchPkg(pkg);
                            if (installInfo.equals((Object)PkgInstallTypes.NOT_INSTALLED)) {
                                if (!info[2].equals(PkgInstallTypes.NOT_INSTALLED.toString())) {
                                    info[2] = PkgInstallTypes.NOT_INSTALLED.toString();
                                }
                            } else if (installInfo.equals((Object)PkgInstallTypes.INSTALLED)) {
                                String[] ver = PlatformLaunchSettingDepPkgPage.this.commander.getVer(pkg);
                                if (!info[1].equals(ver[0])) {
                                    info[1] = ver[0];
                                }
                                if (!info[2].equals(PkgInstallTypes.INSTALLED.toString())) {
                                    info[2] = PkgInstallTypes.INSTALLED.toString();
                                }
                            } else {
                                if (!info[1].isEmpty()) {
                                    info[1] = "";
                                }
                                if (!info[2].equals(PkgInstallTypes.NOT_EXISTS.toString())) {
                                    info[2] = PkgInstallTypes.NOT_EXISTS.toString();
                                }
                            }
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e1) {
            this.logger.error(this.resources.getString("PkgPage.ErrorMsg.UpdatePkg"), (Throwable)e1);
            this.wizard.openErrorDialog(e1.toString());
            e1.printStackTrace();
        }
        this.packageTable.refresh();
        this.setEnableFinish(false);
    }

    private void setEnableFinish(boolean force) {
        boolean setWarnMessage = false;
        if (force) {
            this.setErrorMessage(null);
            this.wizard.setEnableFinish(true);
            this.getContainer().updateButtons();
            return;
        }
        if (this.requiredPkgInfo != null && this.requiredPkgInfo.size() > 0) {
            String pkgName = this.wizard.getCoredumpModel().getCsvo().getHeader().getPackageName();
            String programPath = this.wizard.getProgramPath();
            for (String[] info : this.requiredPkgInfo) {
                String version;
                if (info[0].equals(pkgName) && ((version = info[1]) == null || version.isEmpty())) {
                    String msg = String.format(this.resources.getString("PkgPage.ErrorMsg.DisableFinish"), pkgName);
                    this.setErrorMessage(msg);
                    this.wizard.setEnableFinish(false);
                    this.getContainer().updateButtons();
                    return;
                }
                String string = programPath;
                programPath = "/usr/bin/launchpad-loader";
                if (string.equals("/usr/bin/launchpad-loader") && info[0].equals("aul") && ((version = info[1]) == null || version.isEmpty())) {
                    String msg = String.format(this.resources.getString("PkgPage.ErrorMsg.DisableFinish"), "aul");
                    this.setErrorMessage(msg);
                    this.wizard.setEnableFinish(false);
                    this.getContainer().updateButtons();
                    return;
                }
                if (!info[2].equals(PkgInstallTypes.NOT_INSTALLED.toString()) && !info[2].equals(PkgInstallTypes.NOT_EXISTS.toString())) continue;
                setWarnMessage = true;
            }
        }
        if (setWarnMessage) {
            this.setErrorMessage(null);
            this.setMessage(this.resources.getString("PkgPage.Msg.EnableFinish"));
        } else {
            this.setErrorMessage(null);
        }
        this.wizard.setEnableFinish(true);
        this.getContainer().updateButtons();
    }

    private void checkCancelProcess(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Canceled Job");
        }
    }

    private static class RequiredPkgTableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RequiredPkgTableViewerProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String[]) {
                String[] info = (String[])element;
                String name = info[0];
                String ver = info[1];
                String status = info[2];
                switch (columnIndex) {
                    case 0: {
                        return name;
                    }
                    case 1: {
                        return ver;
                    }
                    case 2: {
                        return status;
                    }
                }
            }
            return null;
        }
    }
}

