/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.IRootstrapManagerProxy;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCoredumpLaunchWizard;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkgmgr.ui.AddRepoDialog;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;

public class PlatformLaunchSettingRootstrapPage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingRootstrapPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private PlatformCoredumpLaunchWizard wizard = null;
    private List<PlatformRootstrap> rootstraps = new ArrayList<PlatformRootstrap>();
    private List<String> rootstrapList = new ArrayList<String>();
    private List<String> repositoryList = new ArrayList<String>();
    private List<Architecture> architectures;
    private String selectedRootstrapName;
    private TableViewer repoTable;
    private Combo rootstrapCombo;
    private Combo archCombo;
    private Button existRootstrap;
    private Button newRootstrap;
    private Text rootstrapText;
    private Button add_bt;
    private Button remove_bt;
    private Button modify_bt;
    private Button moveup_bt;
    private Button movedown_bt;
    protected final Logger logger = LoggerFactory.getLogger(PlatformLaunchSettingRootstrapPage.class);

    public PlatformLaunchSettingRootstrapPage(PlatformCoredumpLaunchWizard wizard, String pageName, Shell shell, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName, shell, project, config, target);
        this.wizard = wizard;
        this.setTitle(this.resources.getString("RtPage.Title"));
        this.setDescription(this.resources.getString("RtPage.Desc"));
        this.setPageComplete(false);
    }

    public void updateRootstrapData() {
        PlatformRootstrap rootstrap;
        this.rootstrapList.clear();
        this.rootstraps.clear();
        if (this.wizard.getCoredumpModel() != null) {
            if (this.wizard.getCoredumpModel().isX86coredump()) {
                IRootstrapManagerProxy iRootstrapManagerProxy = RootstrapProxy.getProxy();
                RootstrapProxy.getProxy();
                for (PlatformRootstrap r : iRootstrapManagerProxy.getRootstraps(8)) {
                    if (!r.isInitialized()) continue;
                    this.rootstraps.add(r);
                }
            } else if (this.wizard.getCoredumpModel().isArmcoredump()) {
                IRootstrapManagerProxy iRootstrapManagerProxy = RootstrapProxy.getProxy();
                RootstrapProxy.getProxy();
                for (PlatformRootstrap r : iRootstrapManagerProxy.getRootstraps(16)) {
                    if (!r.isInitialized()) continue;
                    this.rootstraps.add(r);
                }
            }
        }
        for (PlatformRootstrap r : this.rootstraps) {
            this.rootstrapList.add(r.getName());
        }
        this.rootstrapCombo.setItems(this.rootstrapList.toArray(new String[0]));
        this.rootstrapCombo.select(0);
        this.selectedRootstrapName = this.rootstrapCombo.getText().trim();
        if (this.existRootstrap.getSelection() && this.selectedRootstrapName != null && !this.selectedRootstrapName.isEmpty() && (rootstrap = this.getRootstrap(this.selectedRootstrapName)) != null) {
            List repos = rootstrap.getJustRepoURLs();
            this.UpdateRepositories(repos);
        }
    }

    private PlatformRootstrap getRootstrap(String name) {
        for (PlatformRootstrap r : this.rootstraps) {
            if (!name.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createSelectRootstrapComposite(composite);
        this.createNewRootstrapComposite(composite);
        this.createTableComposite(composite);
        this.setControl((Control)composite);
        this.existRootstrap.setSelection(true);
        this.newRootstrap.setSelection(false);
        this.rootstrapText.setEnabled(false);
        this.archCombo.setEnabled(false);
        this.add_bt.setEnabled(false);
        this.remove_bt.setEnabled(false);
        this.modify_bt.setEnabled(false);
        this.moveup_bt.setEnabled(false);
        this.movedown_bt.setEnabled(false);
    }

    private void createSelectRootstrapComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.existRootstrap = new Button(composite, 16);
        this.existRootstrap.setText(this.resources.getString("RtPage.Button.SelectRt"));
        this.existRootstrap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingRootstrapPage.this.handleSelectExistRootstrap();
            }
        });
        GridData gridData = new GridData(768);
        this.rootstrapCombo = new Combo(composite, 8);
        this.rootstrapCombo.setLayoutData((Object)gridData);
        this.rootstrapCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlatformLaunchSettingRootstrapPage.this.selectedRootstrapName = PlatformLaunchSettingRootstrapPage.this.rootstrapCombo.getText().trim();
                PlatformRootstrap rootstrap = PlatformLaunchSettingRootstrapPage.this.getRootstrap(PlatformLaunchSettingRootstrapPage.this.selectedRootstrapName);
                if (rootstrap != null) {
                    List repos = rootstrap.getJustRepoURLs();
                    PlatformLaunchSettingRootstrapPage.this.UpdateRepositories(repos);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createNewRootstrapComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Composite nameComp = new Composite(composite, 0);
        nameComp.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        nameComp.setLayout((Layout)gridLayout);
        this.newRootstrap = new Button(nameComp, 16);
        this.newRootstrap.setText(this.resources.getString("RtPage.Button.CreateNewRt"));
        this.newRootstrap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingRootstrapPage.this.handleSelectNewRootstrap();
            }
        });
        this.rootstrapText = new Text(nameComp, 2180);
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        this.rootstrapText.setLayoutData((Object)gridData);
        Composite infoComp = new Composite(composite, 0);
        infoComp.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        infoComp.setLayout((Layout)gridLayout);
        Composite archComp = new Composite(composite, 0);
        archComp.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        archComp.setLayout((Layout)gridLayout);
        Label archLabel = new Label(archComp, 16);
        archLabel.setText(this.resources.getString("RtPage.Label.Arch"));
        gridData = new GridData(768);
        this.archCombo = new Combo(archComp, 8);
        this.archCombo.setLayoutData((Object)gridData);
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        composite.setLayoutData((Object)gridData);
        this.createRepositoryTable(composite);
        this.createRepositoryButtons(composite);
    }

    private void createRepositoryTable(Composite parent) {
        Composite t_composite = new Composite(parent, 0);
        t_composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        t_composite.setLayout((Layout)layout);
        this.repoTable = new TableViewer(t_composite, 2304);
        Table table = this.repoTable.getTable();
        GridData tableGridData = new GridData(1808);
        table.setLayoutData((Object)tableGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Repositories"};
        int[] columnWidths = new int[]{1000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ++i;
        }
        this.repoTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createRepositoryButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(2));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.add_bt = new Button(composite, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        this.add_bt.setImage(addIcon);
        this.add_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AddRepoDialog dialog = new AddRepoDialog(PlatformLaunchSettingRootstrapPage.this.shell, "Rootstrap", false);
                if (dialog.open() != 0) {
                    return;
                }
                String url = dialog.getRepositoryURL();
                PlatformLaunchSettingRootstrapPage.this.addRepository(url);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.remove_bt = new Button(composite, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        this.remove_bt.setImage(removeIcon);
        this.remove_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = PlatformLaunchSettingRootstrapPage.this.repoTable.getTable().getSelectionIndex();
                PlatformLaunchSettingRootstrapPage.this.removeRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.modify_bt = new Button(composite, 8);
        Image modifyIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/edit.gif");
        this.modify_bt.setImage(modifyIcon);
        this.modify_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = PlatformLaunchSettingRootstrapPage.this.repoTable.getTable().getSelectionIndex();
                String name = "repository";
                String repo = (String)PlatformLaunchSettingRootstrapPage.this.repoTable.getTable().getItem(selectedIdx).getData();
                ModifyRepoDialog dialog = new ModifyRepoDialog(PlatformLaunchSettingRootstrapPage.this.shell, "Rootstrap", name, repo, false);
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.isDirty()) {
                    String newUrl = dialog.getRepositoryURL();
                    PlatformLaunchSettingRootstrapPage.this.modifyRepository(selectedIdx, newUrl);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.moveup_bt = new Button(composite, 8);
        Image moveupIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-moveup.gif");
        this.moveup_bt.setImage(moveupIcon);
        this.moveup_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = PlatformLaunchSettingRootstrapPage.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx < 1) {
                    return;
                }
                PlatformLaunchSettingRootstrapPage.this.moveUpRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.movedown_bt = new Button(composite, 8);
        Image movedownIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-movedown.gif");
        this.movedown_bt.setImage(movedownIcon);
        this.movedown_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int size = ((List)PlatformLaunchSettingRootstrapPage.this.repoTable.getInput()).size();
                int selectedIdx = PlatformLaunchSettingRootstrapPage.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx >= size - 1) {
                    return;
                }
                PlatformLaunchSettingRootstrapPage.this.moveDownRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void addRepository(String newRepo) {
        List repos = (List)this.repoTable.getInput();
        repos.add(newRepo);
        this.UpdateRepositories(repos);
    }

    private String genRootstrapName() {
        String prefix = "coredump_rootstrap";
        String rootstrapName = "";
        int i = 1;
        while (i < 100) {
            rootstrapName = String.format("%s_%d", prefix, i);
            if (!RootstrapProxy.getProxy().existsRootstrap(rootstrapName)) break;
            ++i;
        }
        return rootstrapName;
    }

    private void moveUpRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index - 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index - 1);
        repos.add(index - 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.UpdateRepositories(repos);
        this.repoTable.getTable().setSelection(index - 1);
    }

    private void moveDownRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index + 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index + 1);
        repos.add(index + 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.UpdateRepositories(repos);
        this.repoTable.getTable().setSelection(index + 1);
    }

    private void modifyRepository(int index, String newRepo) {
        List repos = (List)this.repoTable.getInput();
        repos.remove(index);
        repos.add(index, newRepo);
        this.UpdateRepositories(repos);
    }

    private void removeRepository(int index) {
        String data = (String)this.repoTable.getTable().getItem(index).getData();
        List repos = (List)this.repoTable.getInput();
        ArrayList<String> newRepos = new ArrayList<String>();
        for (String repo : repos) {
            if (repo.equals(data)) continue;
            newRepos.add(repo);
        }
        this.UpdateRepositories(newRepos);
    }

    private void UpdateRepositories(List<String> data) {
        if (data == null) {
            List repos;
            int selectIdx = this.archCombo.getSelectionIndex();
            data = new ArrayList<String>();
            if (selectIdx >= 0 && (repos = this.architectures.get(selectIdx).getRepositories()) != null && !repos.isEmpty()) {
                int idx = 0;
                while (idx < repos.size()) {
                    data.add((String)repos.get(idx));
                    ++idx;
                }
            }
        }
        String selectedArch = this.archCombo.getText();
        this.architectures = new ArrayList<Architecture>();
        for (String url : data) {
            List infos = RootstrapProxy.getProxy().parseRepositoryURL(url, (IProgressMonitor)new NullProgressMonitor());
            this.architectures.addAll(infos);
        }
        this.archCombo.removeAll();
        boolean putData = true;
        for (Architecture arch : this.architectures) {
            String[] items = this.archCombo.getItems();
            putData = true;
            if (items.length > 0) {
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String i = stringArray[n2];
                    if (i.equals(arch.getArch())) {
                        putData = false;
                    }
                    ++n2;
                }
            }
            if (!putData) continue;
            this.archCombo.add(arch.getArch());
        }
        if (this.archCombo.getItemCount() >= 0) {
            this.archCombo.setEnabled(true);
            if (!selectedArch.isEmpty()) {
                int archIndex = this.archCombo.indexOf(selectedArch);
                if (archIndex >= 0) {
                    this.archCombo.select(archIndex);
                } else {
                    this.archCombo.select(0);
                }
            } else {
                this.archCombo.select(0);
            }
        } else {
            this.archCombo.setEnabled(false);
        }
        this.repoTable.setInput(data);
        this.repositoryList.clear();
        this.repositoryList.addAll(data);
        if (this.validPageComplete()) {
            this.setErrorMessage(null);
            this.setMessage(String.format(this.resources.getString("RtPage.Msg.GetRepo"), this.repositoryList.size()));
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(this.resources.getString("RtPage.ErrorMsg.FailedGetRepo"));
            this.setPageComplete(false);
        }
    }

    private boolean validPageComplete() {
        int repoSize = this.repositoryList.size();
        int tableCount = this.repoTable.getTable().getItemCount();
        return tableCount > 0 && repoSize == tableCount;
    }

    private void handleSelectNewRootstrap() {
        this.existRootstrap.setSelection(false);
        this.rootstrapCombo.setEnabled(false);
        this.rootstrapText.setEnabled(true);
        this.rootstrapText.setText(this.genRootstrapName());
        this.add_bt.setEnabled(true);
        this.remove_bt.setEnabled(true);
        this.modify_bt.setEnabled(true);
        this.moveup_bt.setEnabled(true);
        this.movedown_bt.setEnabled(true);
        this.archCombo.removeAll();
        this.repoTable.setInput(new ArrayList());
        this.repositoryList.clear();
        this.setMessage(this.resources.getString("RtPage.Msg.NewRtDesc"));
        this.setPageComplete(false);
    }

    private void handleSelectExistRootstrap() {
        String selected = this.rootstrapCombo.getText();
        this.updateRootstrapData();
        this.newRootstrap.setSelection(false);
        this.rootstrapText.setEnabled(false);
        this.archCombo.setEnabled(false);
        this.add_bt.setEnabled(false);
        this.remove_bt.setEnabled(false);
        this.modify_bt.setEnabled(false);
        this.moveup_bt.setEnabled(false);
        this.movedown_bt.setEnabled(false);
        this.rootstrapCombo.setEnabled(true);
        this.rootstrapCombo.setItems(this.rootstrapList.toArray(new String[0]));
        if (selected != null && !selected.isEmpty()) {
            int idx = this.rootstrapCombo.indexOf(selected);
            if (idx >= 0) {
                this.rootstrapCombo.select(idx);
            } else {
                this.rootstrapCombo.select(0);
                selected = this.rootstrapCombo.getText();
            }
        } else {
            this.rootstrapCombo.select(0);
            selected = this.rootstrapCombo.getText();
        }
        PlatformRootstrap rootstrap = this.getRootstrap(selected);
        if (rootstrap == null) {
            this.setErrorMessage(this.resources.getString("RtPage.ErrorMsg.FailedGetRt"));
            this.wizard.openErrorDialog(this.resources.getString("RtPage.ErrorMsg.FailedGetRt"));
        } else {
            List repos = rootstrap.getJustRepoURLs();
            this.UpdateRepositories(repos);
        }
    }

    public List<String> getRepositryList() {
        return this.repositoryList;
    }

    public boolean selectNewRootstrap() {
        return this.newRootstrap.getSelection();
    }

    public String getRootstrapName() {
        return this.rootstrapText.getText();
    }

    public PlatformRootstrap getSelectedRootstrap() {
        return this.getRootstrap(this.selectedRootstrapName);
    }

    public String getArch() {
        return this.archCombo.getText();
    }
}

