/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class LogTabDialog
extends Dialog {
    private int x = 0;
    private int y = 0;
    private final int width = 700;
    private final int height = 500;
    private String deviceLog = "";
    private String rootstrapLog = "";
    private static final String TITLE = "Show log";

    protected LogTabDialog(Shell parentShell, String deviceLog, String rootstrapLog) {
        super(parentShell);
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 700) / 2;
        this.y = bounds.y + (bounds.height - 500) / 2;
        this.deviceLog = deviceLog;
        this.rootstrapLog = rootstrapLog;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
        newShell.setLocation(this.x, this.y);
        newShell.setSize(700, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTabs(composite);
        return null;
    }

    private void createTabs(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2048);
        GridData data = new GridData(1808);
        tabFolder.setLayoutData((Object)data);
        tabFolder.setLayout((Layout)new GridLayout(1, false));
        this.createDeviceLogTab(tabFolder);
        this.createRootstrapLogTab(tabFolder);
    }

    private void createDeviceLogTab(TabFolder parent) {
        TabItem tab = new TabItem(parent, 0);
        tab.setText("Internal log (Device)");
        Composite composite = new Composite((Composite)parent, 0);
        tab.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTextAreaComposite(composite, this.deviceLog);
    }

    private void createRootstrapLogTab(TabFolder parent) {
        TabItem tab = new TabItem(parent, 0);
        tab.setText("Internal log (Rootstrap)");
        Composite composite = new Composite((Composite)parent, 0);
        tab.setControl((Control)composite);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTextAreaComposite(composite, this.rootstrapLog);
    }

    private void createTextAreaComposite(Composite parent, String log) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Text text = new Text(composite, 2826);
        GridData gridData = new GridData(1808);
        text.setLayoutData((Object)gridData);
        text.setText(log);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

