/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.coredump.CoredumpPreprocessor;
import org.tizen.nativeplatform.launcher.coredump.model.CallStackVO;
import org.tizen.nativeplatform.launcher.coredump.model.CoredumpModel;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingCorePage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingDepPkgPage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingRootstrapPage2;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformCoredumpLaunchWizard
extends PlatformCommonLaunchWizard {
    private PlatformRootstrap selectedRootstrap;
    private CoredumpModel coredumpModel;
    private String installLog = "";
    private String csFileContent = "";
    private String programPath = "";
    private List<String[]> requiredPkgsInfo = new ArrayList<String[]>();
    private static final String SETTING_COREDUMP_PAGE = "setting_coredump";
    private static final String SETTING_ROOTSTRAP_PAGE = "setting_rootstrap";
    private static final String SETTING_DEPPKGS_PAGE = "setting_deppkgs";
    protected final Logger logger = LoggerFactory.getLogger(PlatformCoredumpLaunchWizard.class);

    public PlatformCoredumpLaunchWizard(Shell shell, IProject project, IConfiguration config, PkgCommandTarget target, String mode) {
        super(shell, project, config, target, mode);
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new PlatformLaunchSettingCorePage(this, SETTING_COREDUMP_PAGE, this.shell, this.project, this.config, this.target));
        this.addPage((IWizardPage)new PlatformLaunchSettingRootstrapPage2(this, SETTING_ROOTSTRAP_PAGE, this.shell, this.project, this.config, this.target));
        this.addPage((IWizardPage)new PlatformLaunchSettingDepPkgPage(this, SETTING_DEPPKGS_PAGE, this.shell, this.project, this.config, this.target));
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    @Override
    public boolean canFinish() {
        return this.canFinish;
    }

    @Override
    public void setEnableFinish(boolean value) {
        this.canFinish = value;
    }

    private void changeBuildTarget() {
        String oldTargetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)this.config);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String toolchainId = sbi.getToolchainIDFromTargetID(oldTargetId);
        String oldRootstrapId = sbi.getRootstrapIDFromTargetID(oldTargetId);
        String rootstrapId = this.selectedRootstrap.getId();
        if (!rootstrapId.equals(oldRootstrapId)) {
            String newTargetId = SmartBuildInterface.makeTargetID((String)rootstrapId, (String)toolchainId);
            PlatformConfigurationManager.setBuildTargetName((IConfiguration)this.config, (String)newTargetId);
        }
    }

    @Override
    public boolean performFinish() {
        this.changeBuildTarget();
        return true;
    }

    @Override
    public void handlePageChanging(PageChangingEvent event) {
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        WizardPage targetPage = (WizardPage)event.getTargetPage();
        if (currentPage.getName().equals(SETTING_COREDUMP_PAGE) && targetPage.getName().equals(SETTING_ROOTSTRAP_PAGE)) {
            PlatformLaunchSettingCorePage corePage = (PlatformLaunchSettingCorePage)currentPage;
            PlatformLaunchSettingRootstrapPage2 rootstrapPage = (PlatformLaunchSettingRootstrapPage2)targetPage;
            this.coredumpModel = corePage.getCoredumpModel();
            this.programPath = "/usr/bin/launchpad-loader";
            this.csFileContent = corePage.getCsFileContent();
            rootstrapPage.updateRootstrapData();
        } else if (currentPage.getName().equals(SETTING_ROOTSTRAP_PAGE) && targetPage.getName().equals(SETTING_DEPPKGS_PAGE)) {
            PlatformLaunchSettingDepPkgPage depPkgPage;
            block14: {
                final PlatformLaunchSettingRootstrapPage2 rootstrapPage = (PlatformLaunchSettingRootstrapPage2)currentPage;
                depPkgPage = (PlatformLaunchSettingDepPkgPage)targetPage;
                IWizardContainer container = this.getContainer();
                boolean selectNewRootstrap = false;
                final String crashPackage = this.coredumpModel.getCsvo().getHeader().getPackageName();
                ArrayList<CallStackVO> callStackList = this.coredumpModel.getCsvo().getCallStackList();
                final ArrayList<String> solist = new ArrayList<String>();
                for (CallStackVO stack : callStackList) {
                    String lib;
                    String file;
                    String payLoad = stack.getPayload();
                    int startIdx = payLoad.indexOf(91);
                    int endIdx = payLoad.indexOf(93);
                    if (startIdx <= 0 || endIdx <= 0 || solist.contains(file = new Path(lib = payLoad.substring(startIdx + 1, endIdx)).lastSegment())) continue;
                    solist.add(file);
                }
                this.requiredPkgsInfo.clear();
                final CoredumpPreprocessor processor = new CoredumpPreprocessor();
                try {
                    try {
                        if (!selectNewRootstrap) {
                            container.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask("", 2);
                                    try {
                                        PlatformCoredumpLaunchWizard.this.selectedRootstrap = rootstrapPage.getSelectedRootstrap();
                                        PkgCommandTarget newTarget = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), PlatformCoredumpLaunchWizard.this.selectedRootstrap);
                                        RootstrapProxy.getProxy().winCacheModificationTime(PlatformCoredumpLaunchWizard.this.selectedRootstrap);
                                        processor.setTarget(newTarget);
                                        processor.process(crashPackage, solist, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        RootstrapProxy.getProxy().winSyncronizeIfChanges(PlatformCoredumpLaunchWizard.this.selectedRootstrap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        PlatformCoredumpLaunchWizard.this.requiredPkgsInfo = processor.getRequiredPackageInfo();
                                        Collections.sort(PlatformCoredumpLaunchWizard.this.requiredPkgsInfo, new PkgComparator());
                                    }
                                    finally {
                                        monitor.done();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String log = processor.getLog();
                        String errorMessage = processor.getErrorMessage();
                        if (!log.isEmpty() && !errorMessage.isEmpty()) {
                            this.openLogDialog(errorMessage, log);
                            currentPage.setMessage(errorMessage);
                        } else if (log.isEmpty() && !errorMessage.isEmpty()) {
                            this.openErrorDialog(errorMessage);
                            currentPage.setMessage(errorMessage);
                        } else {
                            this.openErrorDialog(e.toString());
                            currentPage.setMessage(e.toString());
                        }
                        this.cancelChanging(event);
                        this.installLog = processor.getTotalLog();
                        RootstrapProxy.getProxy().removeLatestTempDirForRootstrap();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    this.installLog = processor.getTotalLog();
                    RootstrapProxy.getProxy().removeLatestTempDirForRootstrap();
                    throw throwable;
                }
                this.installLog = processor.getTotalLog();
                RootstrapProxy.getProxy().removeLatestTempDirForRootstrap();
            }
            depPkgPage.updateData();
        }
    }

    public List<String[]> getRequiredPkgsInfo() {
        return this.requiredPkgsInfo;
    }

    @Override
    public String getProgramPath() {
        return this.programPath;
    }

    public void setNewProgramPath(String path) {
        this.programPath = path;
    }

    public PlatformRootstrap getSelectedRootstrap() {
        return this.selectedRootstrap;
    }

    public CoredumpModel getCoredumpModel() {
        return this.coredumpModel;
    }

    public String getInstallLog() {
        return this.installLog;
    }

    public String getCsFileContent() {
        return this.csFileContent;
    }

    private static class PkgComparator
    implements Comparator<String[]> {
        private PkgComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            String pkg1 = o1[0];
            String pkg2 = o2[0];
            return pkg1.compareTo(pkg2);
        }
    }
}

