/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.ExternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.PlatformBuildCommandFactory;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.util.CommonPackageUtil;

public class PlatformExternalBuildRunner
extends ExternalBuildRunner {
    public boolean invokeBuild(int kind, final IProject project, final IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        boolean needCacheChecksum;
        String[] buildArgs = this.getTargets(kind, builder);
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)configuration);
        String rootId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetId);
        PlatformRootstrap rootstrap = RootstrapProxy.getProxy().getRootstrap(rootId);
        if (rootstrap == null) {
            String errMsg = "Please select a rootstrap again";
            throw new CoreException((IStatus)new Status(1, "org.tizen.nativeplatform.builder", errMsg, null));
        }
        boolean bl = needCacheChecksum = !buildArgs[0].equals("clean");
        if (!buildArgs[0].equals("clean")) {
            IBuildCommandProvider provider = PlatformBuildCommandFactory.getProvider(configuration);
            provider.preBuildStep(rootstrap, monitor);
            provider = null;
        }
        UserLogger.start((String)"platform.build");
        boolean isClean = this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
        UserLogger.end((String)"platform.build");
        if (needCacheChecksum) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommonPackageUtil.cachePkgChecksum((IProject)project, (IConfiguration)configuration);
                }
            });
        }
        if (!buildArgs[0].equals("clean")) {
            IBuildCommandProvider provider = PlatformBuildCommandFactory.getProvider(configuration);
            provider.postBuildStep(rootstrap, monitor);
            provider = null;
        }
        return isClean;
    }
}

