/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class PlatformMakeGenerator
implements IManagedBuilderMakefileGenerator2 {
    private IProject project;
    private IPath topBuildDir;
    private IConfiguration config;

    public void generateDependencies() throws CoreException {
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        IFolder configDir = this.project.getFolder(this.config.getName());
        if (!configDir.exists()) {
            return this.regenerateMakefiles();
        }
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, null, null);
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1).removeLastSegments(1);
        }
        return null;
    }

    public String getMakefileName() {
        return null;
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        this.topBuildDir = project.getFolder(info.getConfigurationName()).getFullPath();
        this.config = info.getDefaultConfiguration();
    }

    public boolean isGeneratedResource(IResource resource) {
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        this.topBuildDir = this.createDirectory(this.config.getName());
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, null, null);
    }

    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.project = cfg.getOwner().getProject();
        this.config = cfg;
        this.topBuildDir = this.project.getFolder(cfg.getName()).getFullPath();
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (folder.exists()) {
            folder.delete(true, null);
        }
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }
}

