/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.preferences.PreferencesManager;

public class PlatformProjectDependentBuilder
extends CommonProjectDependentBuilder {
    private static PlatformProjectDependentBuilder instance = new PlatformProjectDependentBuilder();
    private final Logger logger = LoggerFactory.getLogger(PlatformProjectDependentBuilder.class);

    public static final CommonProjectDependentBuilder getInstance() {
        return instance;
    }

    public static final CommonProjectDependentBuilder getInstance(IProject project) {
        instance.setProject(project);
        return instance;
    }

    private PlatformProjectDependentBuilder() {
    }

    private PlatformProjectDependentBuilder(IProject project) {
        super(project);
    }

    protected String getElfInfoOption() {
        return "-s -W";
    }

    protected String getConfigureOption() {
        String options = String.format(" ", new Object[0]);
        return options;
    }

    protected String getMakeOption() {
        return "";
    }

    protected String getCleanOption() {
        return "";
    }

    public String getTargetID() {
        IConfiguration config = this.getConfiguration();
        return PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public String getTargetID(IConfiguration config) {
        return PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public Process debug(String[] arrOption) throws IOException {
        return null;
    }

    public String[] getEnvironment(IConfiguration config) {
        String[] proxyInfo;
        ArrayList<String> newEnvArray = new ArrayList<String>();
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = mngr.getVariables(cfgDes, true);
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        if (PreferencesManager.isProxyUsed() && (proxyInfo = PreferencesManager.getProxyParsedURL()) != null) {
            String protocol = proxyInfo[0];
            String host = proxyInfo[1];
            String port = proxyInfo[2];
            String envKey = String.format("%s_proxy", protocol);
            String envValue = String.format("%s://%s:%s", protocol, host, port);
            envMap.put(envKey, envValue);
        }
        for (Map.Entry entry : envMap.entrySet()) {
            newEnvArray.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return newEnvArray.toArray(new String[0]);
    }

    public String[] getEnvsWithProxy() {
        String[] proxyInfo;
        String[] envs = SmartBuildInterface.getInstance().getEnvironmentVariables();
        if (PreferencesManager.isProxyUsed() && (proxyInfo = PreferencesManager.getProxyParsedURL()) != null) {
            String protocol = proxyInfo[0];
            String host = proxyInfo[1];
            String port = proxyInfo[2];
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            String envKey = String.format("%s_proxy", protocol);
            String envValue = String.format("%s://%s:%s", protocol, host, port);
            envs = sbi.addEnvironmentVariableArray(envKey, envValue);
        }
        return envs;
    }

    public void setBuildTargetID(IConfiguration config, String targetId) {
        PlatformConfigurationManager.setBuildTargetName((IConfiguration)config, (String)targetId);
    }

    public void setToolCommand(IConfiguration config) {
        PlatformConfigurationManager.setToolCommand((IConfiguration)config);
    }

    public void changeToolchain(IConfiguration config, String targetId) {
        PlatformConfigurationManager.changeToolchain((IConfiguration)config, (String)targetId);
    }

    protected String getDebugOption(String[] arrOption) {
        return null;
    }
}

