/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.tizen.common.config.Preference;

public class Configuration {
    private Collection<String> globalKeys;
    private Collection<String> localKeys;

    public Configuration() {
        this.setConfigValues();
    }

    private void setConfigValues() {
        this.globalKeys = Preference.sortedList((String)"TIZEN.CLI.GLOBAL");
        this.localKeys = Preference.sortedList((String)"TIZEN.CLI.LOCAL");
    }

    public Collection<String> getGlobalKeys() {
        return this.globalKeys;
    }

    public Collection<String> getLocalKeys() {
        return this.localKeys;
    }

    public Collection<String> getAllKeys() {
        TreeSet<String> allKeys = new TreeSet<String>();
        allKeys.addAll(this.globalKeys);
        allKeys.addAll(this.localKeys);
        return allKeys;
    }

    public String getValue(String key) {
        if (null != this.localKeys && this.localKeys.contains(key)) {
            return Preference.get((String)"TIZEN.CLI.LOCAL", (String)key);
        }
        if (null != this.globalKeys && this.globalKeys.contains(key)) {
            return Preference.get((String)"TIZEN.CLI.GLOBAL", (String)key);
        }
        return null;
    }

    public String getLocalValue(String localKey) {
        return Preference.get((String)"TIZEN.CLI.LOCAL", (String)localKey);
    }

    public String getGlobalValue(String globalKey) {
        return Preference.get((String)"TIZEN.CLI.GLOBAL", (String)globalKey);
    }

    public Map<String, String> getEnvValueFromCLIConfig(Map<String, String> env) {
        if (env == null) {
            env = new HashMap<String, String>();
        }
        Collection<String> keys = this.getAllKeys();
        for (String key : keys) {
            if (key.length() <= 4 || !key.substring(0, 4).equals("env.")) continue;
            String envKey = key.substring(4, key.length());
            String envValue = System.getenv(key);
            if (envValue != null || (envValue = this.getValue(key)) == null) continue;
            env.put(envKey, envValue);
        }
        return env;
    }
}

