/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.UserField;
import org.tizen.common.core.command.prompter.AbstractPrompter;
import org.tizen.common.core.command.prompter.ChoiceOption;
import org.tizen.common.core.command.prompter.GenericOption;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.util.Assert;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.StringUtil;

public class ConsolePrompter
extends AbstractPrompter
implements Prompter {
    protected final PrintStream out;
    protected final BufferedReader reader;

    public ConsolePrompter(PrintStream out, Reader reader) {
        Assert.notNull((Object)out);
        this.out = out;
        this.reader = new BufferedReader(reader);
    }

    public Option interact(String question, Option ... options) {
        LinkedHashSet<Option> reducedOptions = new LinkedHashSet<Option>();
        Option defaultOption = null;
        ArrayList<String> optionNames = new ArrayList<String>();
        for (Option option : options) {
            if (reducedOptions.contains(option)) {
                throw new IllegalArgumentException("Question can't have duplicated choice(s) :" + option);
            }
            optionNames.add(option.getName());
            reducedOptions.add(option);
            if (!option.isDefault()) continue;
            if (null != defaultOption) {
                throw new IllegalArgumentException("Question must have only one default choice");
            }
            defaultOption = option;
        }
        String choice = null;
        try {
            block3: while (true) {
                this.printQuestion(question, options);
                choice = this.reader.readLine();
                if (StringUtil.isEmpty((CharSequence)choice)) {
                    return defaultOption;
                }
                Option[] optionArray = options;
                int n = optionArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block3;
                    Option option = optionArray[n2];
                    if (option.isMatch(choice)) {
                        return option;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void printQuestion(String question, Option ... options) {
        this.out.print(this.getFullQuestion(question, options));
    }

    private char[] getFullQuestion(String question, Option[] options) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(question + "\n");
        int len = options.length - 1;
        for (int i = 0; i < len; ++i) {
            if (!(options[i] instanceof ChoiceOption)) continue;
            ChoiceOption choiceOption = (ChoiceOption)options[i];
            buffer.append(String.format("%s: (%s), ", choiceOption.getName(), choiceOption.getShortName()));
        }
        if (options[len] instanceof ChoiceOption) {
            ChoiceOption choiceOption = (ChoiceOption)options[len];
            buffer.append(String.format("%s: (%s) ", choiceOption.getName(), choiceOption.getShortName()));
        }
        buffer.append("?");
        return buffer.toString().toCharArray();
    }

    public void notify(String message) {
        this.out.println(message);
    }

    public void cancel() {
    }

    public Object password(String message) {
        this.out.print(StringUtil.trim((String)message));
        this.out.print(" ");
        Console console = System.console();
        return console.readPassword();
    }

    public void error(String message) {
        this.out.println(message);
    }

    public void batch(Collection<UserField> userFields, Map<String, Object> options) {
        this.batch(0, userFields);
    }

    protected void batch(int depth, Collection<UserField> fields) {
        for (UserField child : fields) {
            this.batch(depth, child);
        }
    }

    protected void batch(int depth, UserField field) {
        String msg = field.getMessage();
        Collection supports = field.getSupports();
        if (null != supports && !supports.contains("console")) {
            this.logger.warn("{} is not supported in {}", (Object)field, (Object)this);
            return;
        }
        Class type = field.getType();
        boolean bChild = true;
        if (field.canModify()) {
            if (String.class.equals((Object)type)) {
                GenericOption option = new GenericOption();
                this.interact(this.indent(depth, msg), new Option[]{option});
                if (field.getValue() == null || !StringUtil.isEmpty((CharSequence)option.getAnswer())) {
                    field.setValue((Object)option.getAnswer());
                }
            } else if (char[].class.equals((Object)type) || Character[].class.equals((Object)type)) {
                field.setValue(this.password(this.indent(depth, msg)));
            } else if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
                boolean initValue = null == field.getValue() ? true : (Boolean)field.getValue();
                ChoiceOption yes = new ChoiceOption("Yes", initValue);
                ChoiceOption no = new ChoiceOption("No", !initValue);
                Option opt = this.interact(this.indent(depth, msg), new Option[]{yes, no});
                bChild = yes.equals((Object)opt);
                field.setValue((Object)bChild);
            }
        }
        Collection children = field.getChildren();
        if (bChild && !CollectionUtil.isEmpty((Collection)children)) {
            this.notify(this.indent(depth, msg));
            this.batch(depth + 1, children);
        }
    }

    protected String indent(int depth, String msg) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buffer.append(" ");
        }
        buffer.append(msg);
        return buffer.toString();
    }
}

