/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.core.Tizen;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.config.ConfigCLICommand;
import org.tizen.ncli.util.CommandUtil;

public abstract class AbstractSecurityProfileCLI
extends AbstractCLI {
    public static final String DEFAULT_PROFILE_PATH_VALUE = "";
    public static final String PROFILES_XML_FILENAME = "profiles.xml";

    protected String makeItemTypeName(int ordinal) {
        return ordinal == 0 ? "author" : "distributor" + ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SigningProfileContainer readXML(File file) throws FileNotFoundException {
        SigningProfileContainer signingProfileContainer;
        Assert.notNull((Object)file);
        SigningProfileContainer container = new SigningProfileContainer();
        InputStream in = null;
        try {
            this.log.trace("Read XML.");
            in = new FileInputStream(file);
            in = new BufferedInputStream(in);
            container.readProfileXML(in);
            this.progressLog.info("Loaded in '{}'.", (Object)file);
            this.log.trace("Read Complete.");
            signingProfileContainer = container;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return signingProfileContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeXML(SigningProfileContainer container, File file) throws FileNotFoundException {
        File file2;
        File parentFile;
        this.log.trace("Profiles XML path: {}", (Object)file);
        if (file == null) {
            file = this.getDefaultProfileXMLFile();
            if (file == null) {
                return null;
            }
            this.progressLog.info("In Configuration, Set a default profile path to '{}'.", (Object)file.getPath());
            this.setProfileDirectoryInConfig(file.getPath());
        }
        if ((parentFile = file.getParentFile()) != null && !parentFile.exists() && !parentFile.mkdirs()) {
            this.progressLog.error("Cannot make directories in specified path.");
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            container.writeProfileXML((OutputStream)fos);
            this.progressLog.info("Wrote to '{}'.", (Object)file);
            file2 = file;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fos});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fos});
        return file2;
    }

    protected void setProfileDirectoryInConfig(String path) {
        HashMap<String, String> property = new HashMap<String, String>();
        property.put("profiles.path", path);
        ConfigCLICommand configCommand = new Tizen().config();
        configCommand.setKeyValue(property);
        configCommand.runCommand();
    }

    protected File getSpecifiedProfileDirectory() {
        return this.workingDir != null ? this.getRealWorkingPath() : null;
    }

    protected File getProfileDirectoryInConfig() {
        String configValue = CommandUtil.getConfigValue("profiles.path");
        if (configValue == null) {
            configValue = CommandUtil.getConfigValue("default.profiles.path");
        }
        return configValue != null ? new File(configValue) : null;
    }

    protected File getDefaultProfileXMLFile() {
        String sdkDataPath = InstallPathConfig.getUserDataPath();
        if (sdkDataPath == null) {
            this.log.error("Cannot get the SDK User data path.");
            return null;
        }
        return new File(sdkDataPath + File.separator + "profile", PROFILES_XML_FILENAME);
    }

    protected File getProfileXMLFile() {
        File directory = this.getSpecifiedProfileDirectory();
        this.log.trace("Specified profile directory: {}", (Object)directory);
        if (directory == null) {
            directory = this.getProfileDirectoryInConfig();
            this.log.trace("Profile directory in configuration: {}", (Object)directory);
            if (directory == null) {
                return null;
            }
        }
        if (directory.isDirectory()) {
            return new File(directory, PROFILES_XML_FILENAME);
        }
        return directory;
    }

    protected String buildInformation(SigningProfile profile) {
        StringBuilder builder = new StringBuilder();
        for (SigningProfileItem item : profile.getProfileItems()) {
            if (item == null) continue;
            String itemTypeName = this.makeItemTypeName(profile.getOrdinal(item));
            if (item.hasKeyLocation()) {
                builder.append(itemTypeName).append(" path: ").append(item.getKeyLocation()).append('\n');
            }
            if (item.hasPassword()) {
                String masked = new String(item.getPassword()).replaceAll(".", "*");
                builder.append(itemTypeName).append(" password: ").append(masked).append('\n');
            }
            if (!StringUtil.isEmpty((CharSequence)item.getCAPath())) {
                builder.append(itemTypeName).append(" CA path: ").append(item.getCAPath()).append('\n');
            }
            if (StringUtil.isEmpty((CharSequence)item.getRootCAPath())) continue;
            builder.append(itemTypeName).append(" RootCA path: ").append(item.getRootCAPath()).append('\n');
        }
        return builder.toString();
    }
}

