/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.trustanchor;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.util.DirectoryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@TizenSubCommand(name="unset", usage="Clear the trust-anchor configurations.")
public class TrustAnchorUnsetCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public int execute() {
        File projectPath = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath for trust-anchor add: {}", (Object)projectPath.toString());
        Document doc = null;
        String xmlName = null;
        String trustAnchorPath = null;
        String rootNodeStr = null;
        String trustAnchorNodeStr = null;
        File manifestFile = new File(projectPath, "tizen-manifest.xml");
        File configFile = new File(projectPath, "config.xml");
        if (manifestFile != null && manifestFile.exists()) {
            trustAnchorPath = projectPath + File.separator + "res" + File.separator + ".trust-anchor";
            xmlName = projectPath + File.separator + "tizen-manifest.xml";
            rootNodeStr = "manifest";
            trustAnchorNodeStr = "trust-anchor";
            doc = XMLUtil.readXML((File)manifestFile);
        } else if (configFile != null && configFile.exists()) {
            trustAnchorPath = projectPath + File.separator + ".trust-anchor";
            xmlName = projectPath + File.separator + "config.xml";
            rootNodeStr = "widget";
            trustAnchorNodeStr = "tizen:trust-anchor";
            doc = XMLUtil.readXML((File)configFile);
        } else {
            this.progressLog.error("Please input the valid Tizen project.");
            this.log.error("Please input the valid Tizen project.");
            return -1;
        }
        Node trustAnchorNode = XMLUtil.getDOMNodeT((Document)doc, (String[])new String[]{rootNodeStr, trustAnchorNodeStr});
        if (trustAnchorNode == null) {
            return 0;
        }
        trustAnchorNode.getParentNode().removeChild(trustAnchorNode);
        XMLUtil.writeToFile((Document)doc, (String)xmlName);
        DirectoryUtil.deleteDirectory(new File(trustAnchorPath));
        this.progressLog.error("Succeed to disable the Trust-Anchor.");
        return 0;
    }
}

