/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.tv;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.subcommands.tv.ITVSdbCmd;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;

public class TVSdbCmdSelector {
    public PlatformCapability platformCapabilityChecker;
    public Object tvSdbCmdObj;
    private IDevice device;
    private String version;
    private String arch;
    private float sdbPluginVersion;
    String sdbPluginVer;

    public TVSdbCmdSelector(IDevice device) {
        block12: {
            this.platformCapabilityChecker = null;
            this.tvSdbCmdObj = null;
            this.version = null;
            this.arch = null;
            try {
                this.device = device;
                this.platformCapabilityChecker = device.getPlatformCapability();
                if (this.platformCapabilityChecker.getSecureProtocol().equals("enabled")) {
                    try {
                        String className = this.getSecureCmdClassName();
                        if (className != null) {
                            Class<?> securityCmd = Class.forName(className);
                            this.tvSdbCmdObj = securityCmd.newInstance();
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
                try {
                    String className = this.getNonSecureCmdClassName();
                    if (className != null) {
                        Class<?> nonSecurityCmd = Class.forName(className);
                        this.tvSdbCmdObj = nonSecurityCmd.newInstance();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                try {
                    String className = this.getNonSecureCmdClassName();
                    if (className != null) {
                        Class<?> nonSecurityCmd = Class.forName(className);
                        this.tvSdbCmdObj = nonSecurityCmd.newInstance();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public String getCmd(String key, String param) {
        String cmd = "";
        ((ITVSdbCmd)this.getTVSdbCmdObj()).setPlatformCapabilityInstance(this.platformCapabilityChecker);
        cmd = ((ITVSdbCmd)this.getTVSdbCmdObj()).getCmd(key, param);
        return cmd;
    }

    public Object getTVSdbCmdObj() {
        return this.tvSdbCmdObj;
    }

    private String getSecureCmdClassName() {
        if (this.platformCapabilityChecker == null) {
            return null;
        }
        String productVer = this.platformCapabilityChecker.getProductVersion();
        if (productVer == null || productVer.isEmpty() || productVer.equals("unknown")) {
            return null;
        }
        String verText = productVer.replace(".", "_");
        String secureCmdClassName = "SecureCmdVer" + verText;
        this.version = this.platformCapabilityChecker.getPlatformVersion();
        this.arch = this.platformCapabilityChecker.getCpuArch();
        this.sdbPluginVer = this.platformCapabilityChecker.getSdbdPluginVersion().substring(0, 3);
        if (!this.sdbPluginVer.equals("unknown".substring(0, 3))) {
            this.sdbPluginVersion = Float.valueOf(this.sdbPluginVer).floatValue();
        }
        if (!this.sdbPluginVer.equals("unknown".substring(0, 3)) && (double)this.sdbPluginVersion < 3.4 && this.version.startsWith("4.0") && this.arch.contains("armv7")) {
            return "org.tizen.ncli.subcommands.tv." + secureCmdClassName + "_device";
        }
        return "org.tizen.ncli.subcommands.tv." + secureCmdClassName;
    }

    private String getNonSecureCmdClassName() {
        if (this.platformCapabilityChecker == null) {
            return null;
        }
        String productVer = this.platformCapabilityChecker.getProductVersion();
        if (productVer == null || productVer.isEmpty() || productVer.equals("unknown")) {
            return null;
        }
        String verText = productVer.replace(".", "_");
        String nonSecureCmdClassName = "NonSecureCmdVer" + verText;
        if (!this.sdbPluginVer.equals("unknown".substring(0, 3)) && ((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.version.startsWith("4.0") && this.arch.contains("armv7")) {
            return "org.tizen.ncli.subcommands.tv." + nonSecureCmdClassName + "_device";
        }
        return "org.tizen.ncli.subcommands.tv." + nonSecureCmdClassName;
    }

    public boolean isSecureProtocol() {
        if (this.platformCapabilityChecker == null) {
            return false;
        }
        try {
            return this.platformCapabilityChecker.getSecureProtocol().equals("enabled");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSTV() {
        boolean isSTV;
        block9: {
            isSTV = false;
            String sdkPath = InstallPathConfig.getSDKPath();
            URL[] jarPath = null;
            if (null == sdkPath) {
                return isSTV;
            }
            Path extJarsPath = Paths.get(sdkPath + File.separator + "ide" + File.separator + "plugins", new String[0]);
            String[] currentVendors = new String[]{"Samsung", "HKC", "ATMACA", "TEMPO"};
            List supportedVendors = Arrays.asList(currentVendors);
            if (Files.exists(extJarsPath, new LinkOption[0])) {
                try {
                    Object[] jars = Files.list(extJarsPath).toArray();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (Object jar : jars) {
                        urls.add(new File(jar.toString()).toURI().toURL());
                    }
                    jarPath = new URL[urls.size()];
                    if ((jarPath = urls.toArray(jarPath)) != null) {
                        URLClassLoader loader = new URLClassLoader(jarPath, this.getClass().getClassLoader());
                        Class<?> vendorClass = Class.forName("org.tizen.web.tv.sec.vendorlistprovider.VendorListProvider", true, loader);
                        Method method = vendorClass.getDeclaredMethod("getVendorList", new Class[0]);
                        Object instance = vendorClass.newInstance();
                        supportedVendors = (List)method.invoke(instance, new Object[0]);
                    }
                }
                catch (Exception jars) {
                    // empty catch block
                }
            }
            try {
                PlatformCapability platformCapabilityChecker = this.device.getPlatformCapability();
                String deviceVendor = platformCapabilityChecker.getVendorName();
                if (supportedVendors == null || supportedVendors.isEmpty()) break block9;
                for (String vendor : supportedVendors) {
                    if (!deviceVendor.equals(vendor)) continue;
                    isSTV = true;
                    break;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return isSTV;
    }

    public boolean isAppID(String appID) {
        return Pattern.matches("^[a-zA-Z0-9]{1,}[\\.][a-zA-Z0-9_\\.-]*", appID);
    }
}

