/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util.cryptutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.cryptutil.ICrypt;
import org.tizen.common.sign.util.cryptutil.LinuxCrypt;
import org.tizen.common.util.IOUtil;

public class MacCrypt
implements ICrypt {
    private static final Logger logger = LoggerFactory.getLogger(LinuxCrypt.class);
    private static final String TOOL = "security";
    private static final String ADD = "add-generic-password";
    private static final String FIND = "find-generic-password";
    private static final String SERVICE = "certificate-manager";

    @Override
    public void encrypt(String password, String filename) {
        new Thread(() -> {
            String pswd = StringEscapeUtils.escapeJava((String)password);
            String[] CMD_ARRAY = new String[]{TOOL, ADD, "-a", filename, "-s", SERVICE, "-w", pswd, "-U"};
            try {
                ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
                Process process = builder.start();
                process.waitFor();
            }
            catch (IOException ioe) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)ie);
            }
        }).start();
    }

    @Override
    public String decrypt(String filename) {
        String line;
        block6: {
            String[] CMD_ARRAY = new String[]{TOOL, FIND, "-wa", filename, "-s", SERVICE};
            line = null;
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
                    Process process = builder.start();
                    inputStream = process.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    line = bufferedReader.readLine();
                }
                catch (IOException ioe) {
                    logger.error("Exception occurred while encrypting the password.", (Throwable)ioe);
                    IOUtil.tryClose((Object[])new Object[]{inputStream, bufferedReader});
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream, bufferedReader});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream, bufferedReader});
        }
        if (line != null) {
            return line;
        }
        return "";
    }
}

