/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.appfw.resourcecutter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.appfw.resourcecutter.InputData;
import org.tizen.appfw.resourcecutter.ResourceHandler;
import org.tizen.appfw.resourcecutter.ResourceNode;
import org.tizen.appfw.resourcecutter.Utils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ResourceCutter {
    public static final String FEATURE_DPI = "feature-dpi";
    public static final String VALUE_LDPI = "ldpi";
    public static final String VALUE_MDPI = "mdpi";
    public static final String VALUE_HDPI = "hdpi";
    public static final String VALUE_XHDPI = "xhdpi";
    public static final String VALUE_XXHDPI = "xxhdpi";
    public static final String VALUE_DEFAULT_DPI = "default_hdpi";
    private static final String FEATURE_LANGUAGE = "feature-language";
    private static final String XML_FILE = "res.xml";
    private static final String VALUE_LDPI_DEFAULT = "200";
    private static final String VALUE_MDPI_DEFAULT = "260";
    private static final String VALUE_HDPI_DEFAULT = "320";
    private static final String VALUE_XHDPI_DEFAULT = "400";
    private static final String VALUE_XXHDPI_DEFAULT = "500";
    private static final String VALUE_DEFAULT_DPI_DEFAULT = "-1";
    private final String mBaseDir;
    private Map<String, String> mFeatures;
    private Map<String, InputData> mInputMap;
    private ResourceHandler mHandler;

    private String getFile(int type, String id) {
        String file = null;
        List<ResourceNode> nodes = this.mHandler.getOutput();
        long maxScore = -1L;
        ResourceNode selectedNode = null;
        for (ResourceNode node : nodes) {
            File out;
            long score;
            if (node.getType() != type || (score = node.getScore(this.mFeatures)) < 0L || !(out = new File(node.getPath(this.mBaseDir, id))).exists() || score <= maxScore) continue;
            file = out.getAbsolutePath();
            maxScore = score;
            selectedNode = node;
        }
        if (file != null && selectedNode != null && selectedNode.mIsGroup) {
            for (ResourceNode node : nodes) {
                if (node.mIsGroup || !file.startsWith(node.getPath(this.mBaseDir, ""))) continue;
                return null;
            }
        }
        return file;
    }

    private List<String> getExceptableFiles() {
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> all = new LinkedList<String>();
        Utils.getFileList(all, new File(this.mBaseDir));
        for (String str : all) {
            if (!this.isExceptable(str)) continue;
            list.add(str);
        }
        return list;
    }

    private Set<String> getAllLanguages() {
        HashSet<String> set = new HashSet<String>();
        List<ResourceNode> nodes = this.mHandler.getOutput();
        String lan = null;
        for (ResourceNode node : nodes) {
            lan = node.getLanguage();
            if (lan == null) continue;
            set.add(lan);
        }
        return set;
    }

    private boolean isExceptable(String fileName) {
        List<ResourceNode> nodes = this.mHandler.getOutput();
        for (ResourceNode node : nodes) {
            if (node.isExceptable(fileName, this.mBaseDir)) continue;
            return false;
        }
        return true;
    }

    private void addIds() {
        List<ResourceNode> nodes = this.mHandler.getOutput();
        for (ResourceNode node : nodes) {
            node.addIds(this.mInputMap, this.mBaseDir);
        }
    }

    public ResourceCutter(String baseDir) throws ParserConfigurationException, IOException {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir == null");
        }
        File file = new File(baseDir);
        InputStreamReader r = null;
        this.mBaseDir = String.valueOf(file.getAbsolutePath()) + File.separator;
        try {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                this.mHandler = new ResourceHandler();
                xr.setContentHandler(this.mHandler);
                r = new FileReader(String.valueOf(this.mBaseDir) + XML_FILE);
                xr.parse(new InputSource(r));
            }
            catch (SAXException e) {
                throw new ParserConfigurationException("Invalid xml");
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Set<String> getValidFiles(String[] features, String[] values) {
        if (features.length != values.length) {
            throw new IllegalArgumentException("features.length != values.length");
        }
        this.mFeatures = new HashMap<String, String>();
        this.mInputMap = new HashMap<String, InputData>();
        int i = 0;
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.mFeatures.put(str, values[i]);
            ++i;
            ++n2;
        }
        String valDpi = this.mFeatures.get(FEATURE_DPI);
        if (valDpi != null) {
            if (VALUE_LDPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_LDPI_DEFAULT);
            } else if (VALUE_MDPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_MDPI_DEFAULT);
            } else if (VALUE_HDPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_HDPI_DEFAULT);
            } else if (VALUE_XHDPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_XHDPI_DEFAULT);
            } else if (VALUE_XXHDPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_XXHDPI_DEFAULT);
            } else if (VALUE_DEFAULT_DPI.equals(valDpi)) {
                this.mFeatures.put(FEATURE_DPI, VALUE_DEFAULT_DPI_DEFAULT);
            } else {
                throw new IllegalArgumentException("Invalid DPI");
            }
        }
        HashSet<String> set = new HashSet<String>();
        List<String> list = this.getExceptableFiles();
        set.addAll(list);
        this.addIds();
        Collection<InputData> val = this.mInputMap.values();
        Set<String> lans = this.getAllLanguages();
        lans.add("x");
        for (String lan : lans) {
            for (InputData id : val) {
                this.mFeatures.put(FEATURE_LANGUAGE, lan);
                String file = this.getFile(id.mType, id.mId);
                if (file == null) continue;
                set.add(file);
            }
        }
        return set;
    }

    public Set<String> getAvailableDpi() {
        HashSet<String> set = new HashSet<String>();
        List<ResourceNode> list = this.mHandler.getOutput();
        for (ResourceNode node : list) {
            int dpi = node.getDpi();
            if (dpi < 0) continue;
            if (dpi >= 0 && dpi <= 240) {
                set.add(VALUE_LDPI);
                continue;
            }
            if (dpi >= 241 && dpi <= 300) {
                set.add(VALUE_MDPI);
                continue;
            }
            if (dpi >= 301 && dpi <= 380) {
                set.add(VALUE_HDPI);
                continue;
            }
            if (dpi >= 381 && dpi <= 480) {
                set.add(VALUE_XHDPI);
                continue;
            }
            if (dpi < 481 || dpi > 600) continue;
            set.add(VALUE_XXHDPI);
        }
        set.add(VALUE_DEFAULT_DPI);
        return set;
    }
}

