/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core;

import org.tizen.ncli.core.CommandLineParser;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;

public class CommandInfo
implements Comparable<CommandInfo> {
    private final Class<? extends AbstractCLI> subCmdImpl;
    private String commandName;
    private String usage;
    private boolean hidden;
    private CommandLineParser commandLineParser;

    public String toString() {
        return "CommandInfo [subCmdImpl=" + this.subCmdImpl + ", commandName=" + this.commandName + ", usage=" + this.usage + "]";
    }

    public CommandInfo(Class<? extends AbstractCLI> impl) {
        this.subCmdImpl = impl;
        if (null != impl) {
            TizenSubCommand tizenSubCommand = impl.getAnnotation(TizenSubCommand.class);
            if (null != tizenSubCommand) {
                this.setCommandName(tizenSubCommand.name());
                this.usage = tizenSubCommand.usage();
            } else {
                this.setCommandName(impl.getName());
            }
        } else {
            this.setCommandName("ROOT");
        }
    }

    public CommandInfo(Class<? extends AbstractCLI> impl, String name, String usage, boolean hidden) {
        this.subCmdImpl = impl;
        this.setCommandName(name);
        this.usage = usage;
        this.hidden = hidden;
    }

    public CommandInfo(String command) {
        this.subCmdImpl = null;
        this.commandName = command;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Class<? extends AbstractCLI> getSubCmdImpl() {
        return this.subCmdImpl;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public void setCmdLineParser(CommandLineParser commandLineParser) {
        this.commandLineParser = commandLineParser;
    }

    public CommandLineParser getCmdLineParser() {
        return this.commandLineParser;
    }

    @Override
    public int compareTo(CommandInfo o) {
        if (null == o) {
            return 1;
        }
        if (null != this.subCmdImpl && this.subCmdImpl.equals(o.subCmdImpl)) {
            return 0;
        }
        if (null != o.commandName && o.commandName.equals(this.commandName)) {
            return 0;
        }
        return 1;
    }
}

