/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli.common;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tizen.library.sdkutils.cli.common.Command;
import org.tizen.library.sdkutils.cli.common.Options;

public class Commands {
    private Map<String, Command> commands = new LinkedHashMap<String, Command>();

    public void addCommand(String command, String description) {
        this.commands.put(command, new Command(command, description));
    }

    public void addCommand(String command, String description, Options options) {
        this.commands.put(command, new Command(command, description, options));
    }

    public void addCommand(String shortCmd, String command, String description, Options options) {
        this.commands.put(command, new Command(shortCmd, command, description, options));
    }

    public void addCommand(String shortCmd, String command, String description, Options options, boolean visible) {
        this.commands.put(command, new Command(shortCmd, command, description, options, visible));
    }

    public Command getCommand(String cmdName) {
        Command cmd = this.commands.get(cmdName);
        if (cmd != null) {
            return new Command(cmd);
        }
        return null;
    }

    public boolean containsCommand(String cmdName) {
        return this.commands.containsKey(cmdName);
    }

    public void printHelp() {
        System.out.println(String.format("Usage: %s [global options] <command> [options] ...", "sdk-utils.sh"));
        System.out.println("Global options:");
        System.out.println(String.format("\t%-30s %s", "--help", "Help on a specific command"));
        System.out.println("Commands:");
        for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
            Command cmd = entry.getValue();
            if (cmd.getCommand().equals("--help") || !cmd.isVisible()) continue;
            System.out.println(String.format("\t%-30s %s", cmd.getCommand(), cmd.getDescription()));
        }
    }

    public void printCommendHelp(String command) {
        if (this.commands.containsKey(command)) {
            this.commands.get(command).printHelp();
        }
    }
}

