/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.AbstractCommand;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.InputValidator;
import org.tizen.common.core.command.UserField;
import org.tizen.common.file.FileHandler;
import org.tizen.common.sign.exception.CertificationException;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;

public class ReadSigningProfileFileCommand
extends AbstractCommand<Object> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String path;
    protected SigningProfileContainer container;
    protected String profileName;

    public ReadSigningProfileFileCommand(String path, String profileName) {
        Assert.notNull((Object)path);
        this.path = path;
        this.profileName = profileName;
    }

    public void run(Executor executor, ExecutionContext context) throws Exception {
        if (!this.canRun(context)) {
            return;
        }
        if (this.profileName == null) {
            this.container = SigningProfileUtil.getActiveProfileContainerFromFile(this.path);
            this.profileName = this.container.getActiveProfileName();
        } else {
            this.container = SigningProfileUtil.getSingleProfileContainerFromFile(this.profileName, this.path);
        }
        this.interactForPassword(executor, context);
        this.validateSigningInfo();
    }

    protected void checkPkcs12Password(SigningProfileItem item) throws CertificationException {
        boolean isCorrectPassword = false;
        String path = item.getKeyLocation();
        try {
            char[] pass = item.getPassword();
            String password = pass == null ? "" : new String(pass);
            isCorrectPassword = TizenIncrementalSigner.checkCertificatePassword(path, password);
        }
        catch (FileNotFoundException e) {
            throw new CertificationException("Certificate file not found : " + path, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificationException("Not supported certificate file format", e);
        }
        catch (CertificateException e) {
            throw new CertificationException("Could not load a certificate for PKCS12 format", e);
        }
        catch (KeyStoreException e) {
            throw new CertificationException("Could not find a keystore", e);
        }
        if (!isCorrectPassword) {
            throw new CertificationException("Invaild password");
        }
    }

    protected void validateSigningInfo() throws CertificationException {
        SigningProfile profile = this.getProfile();
        if (profile == null) {
            return;
        }
        for (SigningProfileItem item : profile.getProfileItems()) {
            if (!this.isValidItem(item)) continue;
            this.checkPkcs12Password(item);
        }
    }

    protected void interactForPassword(Executor executor, ExecutionContext context) throws Exception {
        Object[][] fields;
        SigningProfile profile = this.getProfile();
        if (profile == null) {
            return;
        }
        SigningProfileItem authorItem = profile.getProfileItem(0);
        boolean hasAuthor = this.isValidItem(authorItem);
        SigningProfileItem dist1Item = profile.getProfileItem(1);
        boolean hasDist1 = this.isValidItem(dist1Item);
        if (!hasAuthor || !hasDist1) {
            String msg = "Both an author and a first distributor must be required. Please check your profile infomation.";
            context.getPrompter().notify(msg);
            throw new CertificationException(msg);
        }
        SigningProfileItem dist2Item = profile.getProfileItem(2);
        boolean hasDist2 = this.isValidItem(dist2Item);
        if (authorItem.hasPassword() && dist1Item.hasPassword() && (!hasDist2 || dist2Item.hasPassword())) {
            return;
        }
        FileHandler fileHandler = context.getFileHandler();
        InputStream profileInputStream = fileHandler.read(this.path);
        this.container = new SigningProfileContainer();
        this.container.readProfileXML(profileInputStream);
        profile = this.container.getProfileByName(this.profileName);
        IOUtil.tryClose((Object[])new Object[]{profileInputStream});
        if (profile == null) {
            return;
        }
        ArrayList<UserField> fieldList = new ArrayList<UserField>();
        Object[][] objectArrayArray = fields = new Object[][]{{"author", "Author password: ", this.isModifiable(authorItem), authorItem.getPassword(), "Input author password.", "authorPwdSavable", "Save author password"}, {"distributor1", "Distributor1 password: ", this.isModifiable(dist1Item), dist1Item.getPassword(), "Input distributor1 password.", "dist1PwdSavable", "Save distributor1 password"}, {"distributor2", "Distributor2 password: ", this.isModifiable(dist2Item), hasDist2 ? dist2Item.getPassword() : new char[]{}, "Input distributor2 password.", "dist2PwdSavable", "Save distributor2 password"}};
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] field = objectArrayArray[n2];
            String textId = (String)field[0];
            String textMsg = (String)field[1];
            boolean modifiable = (Boolean)field[2];
            char[] password = (char[])field[3];
            String validatorMsg = (String)field[4];
            String buttonId = (String)field[5];
            String buttonMsg = (String)field[6];
            UserField textField = this.createPasswordField(textId, textMsg, modifiable, password, validatorMsg);
            fieldList.add(textField);
            UserField buttonField = this.createButtonField(buttonId, buttonMsg, modifiable);
            fieldList.add(buttonField);
            ++n2;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("title", "Signing Dialog");
        context.getPrompter().batch(fieldList, options);
        boolean[] updateFlags = new boolean[]{(Boolean)fields[0][2], (Boolean)fields[1][2], (Boolean)fields[2][2]};
        int i = 0;
        while (i <= 2) {
            this.updateProfileItem(profile, i, (UserField)fieldList.get(i * 2), (UserField)fieldList.get(i * 2 + 1), updateFlags[i], true);
            ++i;
        }
        this.writeProfiles(executor, context);
        i = 0;
        while (i <= 2) {
            this.updateProfileItem(profile, i, (UserField)fieldList.get(i * 2), (UserField)fieldList.get(i * 2 + 1), updateFlags[i], false);
            ++i;
        }
    }

    protected void updateProfileItem(SigningProfile profile, int ordinal, UserField text, UserField button, boolean modifiable, boolean savable) {
        SigningProfileItem profileItem;
        boolean saveValue = this.getBoolean(button.getValue());
        if (!savable) {
            boolean bl = saveValue = !saveValue;
        }
        if (modifiable && saveValue && (profileItem = profile.removeProfileItem(ordinal)) != null) {
            profileItem.setPassword((char[])text.getValue());
            profile.setProfileItem(ordinal, profileItem);
        }
    }

    protected UserField createPasswordField(String id, String message, boolean modifiable, char[] password, final String validatorMsg) {
        UserField userField = new UserField(id, message, char[].class);
        if (!modifiable) {
            userField.setModify(false);
        } else {
            userField.setValue((Object)password);
            userField.setValidator(new InputValidator(){

                public String check(Object value) {
                    if (value instanceof String) {
                        return StringUtil.isEmpty((CharSequence)((String)value)) ? validatorMsg : null;
                    }
                    return null;
                }
            });
        }
        return userField;
    }

    protected UserField createButtonField(String id, String message, boolean modifiable) {
        UserField userField = new UserField(id, message, Boolean.TYPE);
        if (!modifiable) {
            userField.setModify(false);
        }
        return userField;
    }

    public SigningProfile getProfile() {
        if (this.container == null || this.profileName == null) {
            return null;
        }
        return this.container.getProfileByName(this.profileName);
    }

    protected void writeProfiles(Executor executor, ExecutionContext context) throws Exception {
        FileHandler fileHandler = context.getFileHandler();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.container.writeProfileXML(outStream);
        ByteArrayInputStream in = new ByteArrayInputStream(outStream.toByteArray());
        try {
            fileHandler.write(this.path, (InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
    }

    protected boolean canRun(ExecutionContext context) throws IOException {
        FileHandler fileHandler = context.getFileHandler();
        if (!fileHandler.is(this.path, FileHandler.Attribute.EXISTS)) {
            return false;
        }
        if (!fileHandler.is(this.path, FileHandler.Attribute.READABLE)) {
            return false;
        }
        return FileHandler.Type.FILE.equals(fileHandler.get(this.path, FileHandler.Attribute.TYPE));
    }

    protected boolean isValidItem(SigningProfileItem item) {
        return item == null ? false : item.hasKeyLocation();
    }

    protected boolean isModifiable(SigningProfileItem item) {
        if (!this.isValidItem(item)) {
            return false;
        }
        char[] password = item.getPassword();
        return password == null || StringUtil.isEmpty((CharSequence)new String(password));
    }

    protected boolean getBoolean(Object obj) {
        return obj == null ? true : Boolean.parseBoolean(String.valueOf(obj));
    }
}

