/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.util.ArrayList;
import org.tizen.common.sign.model.AbstractSignatureXml;
import org.tizen.common.sign.model.FeatureDPI;
import org.w3c.dom.Document;

public class AuthorSignatureXml
extends AbstractSignatureXml {
    public static final String FILENAME = "author-signature.xml";
    private String filename;

    public AuthorSignatureXml(Document document) {
        super(document);
        this.filename = FILENAME;
    }

    public AuthorSignatureXml(Document document, FeatureDPI dpi) {
        super(document);
        this.filename = dpi.getSignatureFilename();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public static boolean is(String filename) {
        if (FILENAME.equalsIgnoreCase(filename)) {
            return true;
        }
        FeatureDPI[] featureDPIArray = FeatureDPI.values();
        int n = featureDPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDPI dpi = featureDPIArray[n2];
            if (dpi.getSignatureFilename().equalsIgnoreCase(filename)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] getAvailableFilename() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(FILENAME);
        FeatureDPI[] featureDPIArray = FeatureDPI.values();
        int n = featureDPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDPI dpi = featureDPIArray[n2];
            list.add(dpi.getSignatureFilename());
            ++n2;
        }
        return list.toArray(new String[0]);
    }
}

