/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.coverage.GenCoverageCommand;

@TizenSubCommand(name="gen-coverage", usage="Generate Coverage Info for native unit test project")
public class GenCoverageCLI
extends AbstractCLI {
    @Option(name="-c", aliases={"--covFile"}, metaVar="<covFile>", usage="Specify the path of coverage file to be used to generate report.")
    private String covFile;
    @Option(name="-p", aliases={"--projs"}, metaVar="<projs>", usage="Specify comma separated projects to use for coverage generation.")
    private String projs;
    @Option(name="-T", aliases={"--toolchain"}, metaVar="<toolchain>", usage="Path of LLVM Toolchain to be used")
    private String toolchain;
    @Option(name="-C", aliases={"--config"}, metaVar="Build Configuration to use", usage="Specify the Build configuration to use. Should be same for all projects")
    private String config;
    @Option(name="-o", aliases={"--out"}, metaVar="Output folder", usage="Specify the output folder to create coverage reports")
    private String outFolder;

    @Override
    public int execute() {
        GenCoverageCommand genCovCmd = new GenCoverageCommand();
        if (this.config == null) {
            this.config = "Debug";
        }
        genCovCmd.setConfig(this.config);
        genCovCmd.setWorkingDir(this.getRealWorkingPath());
        genCovCmd.setCovFile(this.covFile);
        genCovCmd.setProjs(this.projs);
        genCovCmd.setOutFolder(this.outFolder);
        genCovCmd.setToolchainPath(this.toolchain);
        genCovCmd.runCommand();
        return 0;
    }
}

