/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build;

import java.util.ArrayList;
import java.util.List;

public class BuildMethodData {
    protected String projectPath;
    protected String profileName;
    protected String profileVersion;
    protected String architecture;
    protected String rootstrapName;
    protected String buildConfig;
    protected String toolchain;
    protected String extraOpts;
    protected List<String> predefineOptions;

    public BuildMethodData() {
    }

    public BuildMethodData(String profileName, String profileVersion, String architecture, String rootstrapName, String buildConfig, String toolchain, List<String> predefineOptions, String extraOpts, int jobs, String buildScriptPath) {
        this.profileName = profileName;
        this.profileVersion = profileVersion;
        this.architecture = architecture;
        this.rootstrapName = rootstrapName;
        this.toolchain = toolchain;
        this.extraOpts = extraOpts;
        this.predefineOptions = predefineOptions;
        this.buildConfig = buildConfig;
    }

    public BuildMethodData(BuildMethodData baseMethod) {
        if (baseMethod != null) {
            this.profileName = baseMethod.profileName;
            this.profileVersion = baseMethod.profileVersion;
            this.architecture = baseMethod.architecture;
            this.rootstrapName = baseMethod.rootstrapName;
            this.toolchain = baseMethod.toolchain;
            this.predefineOptions = baseMethod.predefineOptions;
            this.extraOpts = baseMethod.extraOpts;
            this.buildConfig = baseMethod.buildConfig;
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getRootstrapName() {
        return this.rootstrapName;
    }

    public void setRootstrapName(String rootstrapName) {
        this.rootstrapName = rootstrapName;
    }

    public String getBuildConfig() {
        return this.buildConfig;
    }

    public void setBuildConfig(String buildConfig) {
        this.buildConfig = buildConfig;
    }

    public String getToolchain() {
        return this.toolchain;
    }

    public void setToolchain(String toolchain) {
        this.toolchain = toolchain;
    }

    public String getExtraOpts() {
        return this.extraOpts;
    }

    public void setExtraOpts(String opts) {
        this.extraOpts = opts;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        this.profileVersion = profileVersion;
    }

    public void setProfileFullName(String profileFullName) {
        if (profileFullName == null || profileFullName.isEmpty()) {
            this.profileName = null;
            this.profileVersion = null;
            return;
        }
        String[] s = profileFullName.split("-");
        if (s.length > 0) {
            if (s.length >= 1) {
                this.profileName = s[0];
            }
            if (s.length >= 2) {
                this.profileVersion = s[1];
            }
        }
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public List<String> getPredefineOptions() {
        return this.predefineOptions;
    }

    public void setPredefineOptions(List<String> predefineOptions) {
        this.predefineOptions = predefineOptions;
    }

    public void setPredefineOptions(String[] predefineOptions) {
        if (predefineOptions != null) {
            this.predefineOptions = new ArrayList<String>();
            for (String def : predefineOptions) {
                this.predefineOptions.add(def);
            }
        } else {
            this.predefineOptions = null;
        }
    }

    public boolean isEmpty() {
        if (this.profileName != null && !this.profileName.isEmpty()) {
            return false;
        }
        if (this.profileVersion != null && !this.profileVersion.isEmpty()) {
            return false;
        }
        if (this.architecture != null && !this.architecture.isEmpty()) {
            return false;
        }
        if (this.rootstrapName != null && !this.rootstrapName.isEmpty()) {
            return false;
        }
        if (this.buildConfig != null && !this.buildConfig.isEmpty()) {
            return false;
        }
        if (this.toolchain != null && !this.toolchain.isEmpty()) {
            return false;
        }
        return this.predefineOptions == null || this.predefineOptions.isEmpty();
    }

    public void merge(BuildMethodData addMethod) {
        if (addMethod.profileName != null) {
            this.profileName = addMethod.profileName;
        }
        if (addMethod.profileVersion != null) {
            this.profileVersion = addMethod.profileVersion;
        }
        if (addMethod.architecture != null) {
            this.architecture = addMethod.architecture;
        }
        if (addMethod.rootstrapName != null) {
            this.rootstrapName = addMethod.rootstrapName;
        }
        if (addMethod.buildConfig != null) {
            this.buildConfig = addMethod.buildConfig;
        }
        if (addMethod.toolchain != null) {
            this.toolchain = addMethod.toolchain;
        }
        if (addMethod.predefineOptions != null && !addMethod.predefineOptions.isEmpty()) {
            if (this.predefineOptions == null) {
                this.predefineOptions = new ArrayList<String>();
            }
            this.predefineOptions.addAll(addMethod.predefineOptions);
        }
    }
}

