/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.util.ParsingUtil;

public class FileEntryUtil {
    public static long getTotalSize(FileEntry[] entries, ISyncProgressMonitor monitor) throws InterruptedException {
        long count = 0L;
        FileEntry[] fileEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FileEntry e = fileEntryArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedException("The long running operation was cancelled");
            }
            FileEntryType type = e.getType();
            if (type.canHaveChild()) {
                long folderSize = e.getFolderTotalSize();
                if (folderSize == -1L) {
                    return -1L;
                }
                count += folderSize;
            } else if (type == FileEntryType.File) {
                count += ParsingUtil.parseLong(e.getSize(), 0L);
            }
            ++n2;
        }
        return count;
    }
}

