/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.tizen.common.builder.Resource;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.Assert;

public class ResourceLayer {
    protected final String name;
    protected ResourceLayer parent;
    protected final FileHandler fileHandler;
    protected final Collection<Resource> filter = new HashSet<Resource>();

    public ResourceLayer(FileHandler fileHandler) {
        this("Unknown", null, fileHandler);
    }

    public ResourceLayer(String name, FileHandler fileHandler) {
        this(name, null, fileHandler);
    }

    public ResourceLayer(ResourceLayer parent, FileHandler fileHandler) {
        this(null, parent, fileHandler);
    }

    public ResourceLayer(String name, ResourceLayer parent, FileHandler fileHandler) {
        Assert.notNull((Object)fileHandler);
        this.name = name;
        this.parent = parent;
        this.fileHandler = fileHandler;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLayer getParent() {
        return this.parent;
    }

    public void setParent(ResourceLayer parent) {
        this.parent = parent;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public Resource getResource(String path) throws IOException {
        if (!((Boolean)this.fileHandler.get(path, FileHandler.Attribute.EXISTS)).booleanValue()) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getResource(path);
        }
        Resource result = new Resource(this, path);
        if (this.isFilterResource(result)) {
            return null;
        }
        return result;
    }

    public Resource addResource(String path, byte[] contents) throws IOException {
        Resource ret = new Resource(this, path);
        ret.setContents(contents);
        return ret;
    }

    public Resource addResource(String path, InputStream in) throws IOException {
        Resource ret = new Resource(this, path);
        ret.setContents(in);
        return ret;
    }

    public void removeResource(String path) throws IOException {
        if (this.fileHandler.is(path, FileHandler.Attribute.EXISTS)) {
            this.fileHandler.removeFile(path);
        }
    }

    public void addFilterResource(Resource res) {
        this.filter.add(res);
    }

    public Resource[] getFilterResources() {
        return this.filter.toArray(new Resource[0]);
    }

    public boolean isFilterResource(IResource res) {
        return this.filter.contains(res);
    }

    public void removeFilterResource(Resource res) {
        this.filter.remove((Object)res);
    }

    public String toString() {
        return "Layer[" + this.name + "]";
    }
}

