/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import javax.swing.JOptionPane;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IStartup;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.page.preference.LoggingPreferencePage;
import org.tizen.common.util.DialogUtil;
import org.tizen.sdblib.ICrashReportServiceListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.service.CrashReportService;

public class CommonStartup
implements IStartup {
    private static Logger logger;
    public static final String PRODUCT_NAME = "TizenStudio";

    public void earlyStartup() {
        IEclipsePreferences corePrefs = InstanceScope.INSTANCE.getNode("org.tizen.common");
        corePrefs.put("installerLogFileName", LoggingPreferencePage.getLogLocation());
        corePrefs.put("loggerLevel", LoggingPreferencePage.getLoggerLevel().toString());
        corePrefs.put("loggerPattern", LoggingPreferencePage.getLogConversionPattern());
        new Thread("Start SmartDevelopmentBridge"){

            @Override
            public void run() {
                CommonStartup.this.startSmartDevelopmentBridge();
                CommonStartup.this.Deprecated_message();
            }
        }.start();
        try {
            this.initializeCrashReportService();
        }
        catch (ServerException serverException) {}
    }

    private void Deprecated_message() {
        JOptionPane.showMessageDialog(null, "<html>Tizen Studio and Dynamic Analyzer are supported only up to Tizen-9.0.<br>There will be no further updates beyond this version.</html>", "Tizen Studio", 2);
    }

    private void startSmartDevelopmentBridge() {
        SmartDevelopmentBridge bridge = SmartDevelopmentBridge.getBridge();
        if (bridge != null) {
            bridge.startBridge();
            try {
                bridge.waitforStart(5000L);
                if (!bridge.getStarted()) {
                    DialogUtil.openErrorDialog("Failed to start sdb");
                    bridge.stopBridge();
                }
                String sdbLogPath = InstallPathConfig.getIdeUserDataLogPath();
                bridge.setSdbLogLocation(sdbLogPath);
            }
            catch (Throwable t) {
                CommonPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.tizen.common", "Problem occurred while initializing sdb", t));
                DialogUtil.openErrorDialog("Failed to start sdb");
            }
        }
    }

    protected void initializeCrashReportService() throws ServerException {
        IConfigurationElement[] ces;
        IExtensionRegistry x = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = ces = x.getConfigurationElementsFor("org.tizen.common.crashreporter");
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("client".equals(ce.getName()) && (className = ce.getAttribute("class")) != null) {
                try {
                    Object obj = ce.createExecutableExtension("class");
                    if (obj instanceof ICrashReportServiceListener) {
                        CrashReportService.getDefault().addCrashReportServiceListener((ICrashReportServiceListener)obj);
                    }
                }
                catch (CoreException e) {
                    CommonPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.tizen.common", "Error occurred while adding cs create listener", (Throwable)e));
                }
            }
            ++n2;
        }
        CrashReportService.getDefault().boot();
    }
}

