/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.config.ExpressionParser;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ParsingUtil;

public class Preference {
    protected static final Logger logger = LoggerFactory.getLogger(Preference.class);
    protected static final ArrayList<PreferenceProvider> providers = new ArrayList();
    protected static final HashMap<String, PreferenceProvider> name2provider = new HashMap();

    protected Preference() {
    }

    public static void clear() {
        providers.clear();
        name2provider.clear();
    }

    protected static final boolean checkName(String name) {
        char[] chars = name.toCharArray();
        int i = 0;
        int n = chars.length;
        while (i < n) {
            if (!Character.isJavaIdentifierPart(chars[i]) && '.' != chars[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void register(String name, PreferenceProvider provider) {
        if (name != null && !Preference.checkName(name)) {
            return;
        }
        PreferenceProvider old = name2provider.put(name, provider);
        if (old != null) {
            providers.set(providers.indexOf(old), provider);
        } else {
            providers.add(0, provider);
        }
    }

    public static String get(String key) {
        logger.info("Key :{}", (Object)key);
        for (PreferenceProvider provider : providers) {
            String exp = provider.get(key);
            logger.debug("Provider :{}, Value :{}", (Object)provider, (Object)exp);
            if (exp == null) continue;
            return exp;
        }
        return null;
    }

    public static String get(String namespace, String key) {
        Assert.notNull(namespace);
        logger.info("Namespace :{}, Key :{}", (Object)namespace, (Object)key);
        PreferenceProvider provider = name2provider.get(namespace);
        if (provider != null) {
            String exp = provider.get(key);
            logger.debug("Provider :{}, Value :{}", (Object)provider, (Object)exp);
            return exp;
        }
        return null;
    }

    public static Collection<String> list(String name) {
        HashSet<String> keys = new HashSet<String>();
        return Preference.addAllKeys(name, keys);
    }

    public static Collection<String> sortedList(String name) {
        TreeSet<String> keys = new TreeSet<String>();
        return Preference.addAllKeys(name, keys);
    }

    private static Collection<String> addAllKeys(String name, Set<String> keys) {
        PreferenceProvider preferenceProvider = name2provider.get(name);
        if (preferenceProvider != null) {
            keys.addAll(preferenceProvider.keys());
        }
        return Collections.unmodifiableCollection(keys);
    }

    public static String getValue(String key, String defaultValue) {
        String exp = Preference.get(key);
        if (exp == null) {
            if (defaultValue == null) {
                return null;
            }
            return ExpressionParser.parse(defaultValue);
        }
        return ExpressionParser.parse(exp);
    }

    public static int getInteger(String key, int defaultValue) {
        String value = Preference.getValue(key, null);
        return ParsingUtil.parseInt(value, defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Preference.getValue(key, null);
        return ParsingUtil.parseBoolean(value, defaultValue);
    }
}

