/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command;

import org.tizen.common.Factory;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.policy.AbstractPolicy;
import org.tizen.common.core.command.policy.FilePolicy;
import org.tizen.common.core.command.policy.MessagePolicy;
import org.tizen.common.core.command.policy.OptionPolicy;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.policy.SimplePolicy;
import org.tizen.common.core.command.policy.UncaughtExceptionHandlingPolicy;
import org.tizen.common.core.command.prompter.FileHandlingOption;

public class PolicyRegistryFactory
implements Factory<PolicyRegistry> {
    @Override
    public PolicyRegistry create() {
        PolicyRegistry registry = new PolicyRegistry(new Policy[0]);
        registry.register(new EclipsePolicy(this, "exist.file.when.copy"){

            @Override
            public <T> T adapt(Class<T> clazz) {
                if (clazz.isAssignableFrom(OptionPolicy.class)) {
                    return (T)new OptionPolicy(FileHandlingOption.OVERWRITE, FileHandlingOption.IGNORE, FileHandlingOption.OVERWRITE_ALL, FileHandlingOption.IGNORE_ALL, FileHandlingOption.CANCEL);
                }
                return super.adapt(clazz);
            }
        });
        registry.register(new EclipsePolicy(this, "exception.unhandled"){

            @Override
            public <T> T adapt(Class<T> clazz) {
                if (clazz.isAssignableFrom(UncaughtExceptionHandlingPolicy.class)) {
                    return (T)UncaughtExceptionHandlingPolicy.INSTANCE;
                }
                return null;
            }
        });
        registry.register(new EclipsePolicy("exist.file.out"));
        registry.register(new EclipsePolicy("nonexist.file.in"));
        registry.register(new SimplePolicy("printout.result.signing"));
        registry.register(new EclipsePolicy("nonexist.dir.in.project"));
        return registry;
    }

    class EclipsePolicy
    extends AbstractPolicy {
        public EclipsePolicy(String name) {
            super(name);
        }

        @Override
        public <T> T adapt(Class<T> clazz) {
            if (clazz.isAssignableFrom(FilePolicy.class)) {
                return (T)((Object)FilePolicy.STOP_PROCESS);
            }
            if (clazz.isAssignableFrom(MessagePolicy.class)) {
                return (T)MessagePolicy.PROMPTER;
            }
            if (clazz.isAssignableFrom(UncaughtExceptionHandlingPolicy.class)) {
                return (T)UncaughtExceptionHandlingPolicy.INSTANCE;
            }
            return null;
        }
    }
}

