/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.StringUtil;

public abstract class AbstractFileHandler
implements FileHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean is(String path, FileHandler.Attribute name) throws IOException {
        Object obj = this.get(path, name);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    @Override
    public void makeDirectory(String path, boolean recursive) throws IOException {
        if (StringUtil.isEmpty(path)) {
            return;
        }
        if (recursive) {
            if (this.is(path, FileHandler.Attribute.EXISTS)) {
                return;
            }
            String parentDir = FilenameUtil.removeTailingPath(path, 1);
            if (!this.is(parentDir, FileHandler.Attribute.EXISTS)) {
                this.makeDirectory(parentDir, true);
            }
        }
        this.makeDirectory(path);
    }

    public String toString() {
        String cwd = this.getCurrentWorkingDirectory();
        return cwd != null ? cwd : super.toString();
    }
}

