/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.classloader.ClassSource;
import org.tizen.common.classloader.CustomClassLoader;
import org.tizen.common.classloader.JarClassSource;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.AttributeConfiguable;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.util.QueryFactory;

public class RealmFactory
implements FactoryWithArgument<Realm, URL> {
    protected static final RealmFactory instance = new RealmFactory();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static RealmFactory getInstance() {
        return instance;
    }

    protected Map<String, String> parseRealm(InputStream in, String contentType) throws IOException {
        HashMap<String, String> attrs = null;
        byte[] bytes = IOUtil.getBytes((InputStream)in);
        this.logger.debug("Realm config :\n{}", (Object)new String(bytes));
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        attrs = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.readValue((InputStream)byteIn, JsonNode.class);
        Iterator iter = node.getFieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JsonNode jsonNode = node.get(key);
            if (jsonNode == null) continue;
            attrs.put(key, jsonNode.asText());
        }
        this.logger.debug("Realm Attributes :{}", attrs);
        return attrs;
    }

    public Realm create(URL url) {
        Realm realm;
        URLConnection con = url.openConnection();
        con.connect();
        InputStream in = con.getInputStream();
        try {
            String contentType = StringUtil.nvl((String[])new String[]{con.getContentType(), "application/json"});
            this.logger.debug("Contents mime :{}", (Object)contentType);
            Map<String, String> attrs = this.parseRealm(in, contentType);
            if (attrs == null) {
                throw new IllegalArgumentException("Realm[" + url + "] not found");
            }
            String loader = QueryFactory.getInstance().query(attrs.get("loader"), new HashMap<String, Object>());
            this.logger.debug("Loader :{}", (Object)loader);
            JarClassSource source = new JarClassSource(loader);
            this.logger.debug("Source :{}", (Object)source);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            this.logger.debug("Context classloader :{}", (Object)old);
            CustomClassLoader cl = new CustomClassLoader(Thread.currentThread().getContextClassLoader(), new ClassSource[]{source});
            Realm realm2 = this.load((ClassLoader)cl, attrs);
            if (realm2 == null) {
                this.logger.warn("Realm[{}] not found", (Object)loader);
            }
            realm = realm2;
        }
        catch (Throwable throwable) {
            try {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return realm;
    }

    protected Realm load(ClassLoader cl, Map<String, String> attrs) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.logger.trace("ClassLoader :{}", (Object)cl);
        Enumeration<URL> manifestUrls = cl.getResources("META-INF/MANIFEST.MF");
        while (manifestUrls.hasMoreElements()) {
            String realmName;
            InputStream manifestIn;
            block5: {
                URL url = manifestUrls.nextElement();
                manifestIn = url.openStream();
                if (manifestIn == null) continue;
                try {
                    realmName = this.getRealmName(manifestIn);
                    if (realmName != null) break block5;
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{manifestIn});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{manifestIn});
                continue;
            }
            Class<?> clazz = cl.loadClass(realmName);
            Realm realm = (Realm)clazz.newInstance();
            if (realm instanceof AttributeConfiguable) {
                ((AttributeConfiguable)((Object)realm)).setAttributes(attrs);
            }
            Realm realm2 = realm;
            IOUtil.tryClose((Object[])new Object[]{manifestIn});
            return realm2;
        }
        return null;
    }

    public String getRealmName(InputStream in) throws IOException {
        String string;
        try {
            byte[] contents = IOUtil.getBytes((InputStream)in);
            Manifest m = new Manifest(new ByteArrayInputStream(contents));
            Attributes attrs = m.getMainAttributes();
            String realmName = StringUtil.trim((String)attrs.getValue("Tizen-Template-Realm"));
            if (realmName != null) {
                this.logger.info("Realm name :{}", (Object)realmName);
            }
            string = realmName;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return string;
    }
}

