/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.engine.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FreeMarkerUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.engine.AbstractTemplateEngine;
import org.tizen.common.verrari.engine.freemarker.FreemarkerModelManager;
import org.tizen.common.verrari.engine.freemarker.FreemarkerTemplateProvider;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    protected final Configuration cfg = FreeMarkerUtil.getDefaultConfiguration();

    public FreemarkerTemplateEngine() {
        this.cfg.setTemplateLoader((TemplateLoader)new FreemarkerTemplateProvider(this.getTemplateProvider()));
    }

    @Override
    public void setTemplateProvider(ITemplateProvider provider) {
        super.setTemplateProvider(provider);
        if (this.cfg != null) {
            this.cfg.setTemplateLoader((TemplateLoader)new FreemarkerTemplateProvider(provider));
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    @Override
    public String getEngineVersion() {
        return Configuration.getVersionNumber();
    }

    @Override
    public void generate(String templateKey, IModelProvider modelProvider, OutputStream output) throws Exception {
        Template freemarkerTemplate = this.cfg.getTemplate(templateKey);
        Assert.notNull((Object)freemarkerTemplate, (String)("Template is null for " + templateKey));
        FreemarkerModelManager adapter = new FreemarkerModelManager(modelProvider);
        freemarkerTemplate.process((Object)adapter, (Writer)new OutputStreamWriter(output));
    }
}

