/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.File;
import java.util.Collection;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.template.FileTemplate;
import org.tizen.common.verrari.template.TemplateTransformer;
import org.tizen.common.verrari.template.TransformableTemplate;

public class FileTemplateProvider
implements ITemplateProvider {
    protected TemplateTransformer transformer;
    protected File root;

    public FileTemplateProvider() {
        this(new File("."));
    }

    public FileTemplateProvider(File root) {
        this.root = root;
    }

    @Override
    public boolean isEmpty() {
        return ArrayUtil.size((Object[])this.root.list()) == 0;
    }

    @Override
    public Collection<String> keys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITemplate getTemplate(String key) {
        File file = new File(key);
        FileTemplate template = null;
        template = file.isAbsolute() ? new FileTemplate(file) : new FileTemplate(new File(this.root, key));
        return new TransformableTemplate(this.transformer, template);
    }

    @Override
    public void setTransformer(TemplateTransformer transformer) {
        this.transformer = transformer;
    }
}

