/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildcs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.IOUtil;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSData;
import org.tizen.ncli.util.DotnetUtil;

public class BuildCSCommand {
    protected static final Logger log = LoggerFactory.getLogger(AbstractSubCommand.class);
    protected static final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean backupBeforeBuild(BuildCSData data) {
        BufferedReader br = null;
        BufferedWriter bw = null;
        Set<String> projects = data.getCsProjects();
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        for (String csproj : projects) {
            File f = new File(csproj);
            try {
                f.renameTo(new File(csproj + ".backup"));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            try {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(csproj + ".backup")), "UTF8"));
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csproj), "UTF8"));
                while ((line = br.readLine()) != null) {
                    if (line.contains("<DebugSymbols>")) {
                        line = line.replace("true", "false");
                    }
                    bw.write(line);
                    bw.newLine();
                }
            }
            catch (Exception e) {
                boolean bl;
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{br, bw});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{br, bw});
                return bl;
            }
            IOUtil.tryClose((Object[])new Object[]{br, bw});
        }
        return true;
    }

    public static boolean restoreAfterBuild(BuildCSData data, String configuration) {
        String buildInfoPath = null;
        File projFile = null;
        Set<String> projects = data.getCsProjects();
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        for (String proj : projects) {
            projFile = new File(proj);
            File buildOutput = DotnetUtil.getBuildOutputPath(proj, configuration);
            if (buildOutput != null && buildOutput.exists()) {
                buildInfoPath = FileUtil.appendPath((String)buildOutput.getPath(), (String)"build.info");
                File projDir = projFile.getParentFile();
                if (projDir != null) {
                    data.writeBuildInfo(buildInfoPath, projDir.getPath());
                }
            } else {
                log.warn("build output directory ({}) does not exist.", (Object)proj);
            }
            try {
                if (!projFile.delete()) {
                    log.error("Unable to delete");
                }
                if (new File(proj + ".backup").renameTo(projFile)) continue;
                log.error("Unable to rename");
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return true;
    }
}

