/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.listcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createcsharp.CSTemplateInfo;
import org.tizen.ncli.subcommands.createcsharp.CreateCSProjectCommandData;
import org.tizen.ncli.subcommands.listcs.ListCSProject;
import org.tizen.ncli.subcommands.listcs.TemplateCompare;

public class ListCSProjectCLICommand
extends AbstractSubCommand<ListCSProject> {
    private final String VIEW_FORMAT = "%-20s %s";
    private final String TITLE_FORMAT = String.format("%-20s %s", "[VERSION]", "[TEMPLATE]");

    @Override
    protected ListCSProject call() {
        Map<String, CSTemplateInfo> templates = CreateCSProjectCommandData.getTemplateList();
        ListCSProject list = new ListCSProject();
        if (templates != null && !templates.isEmpty()) {
            this.progressLog.info(this.TITLE_FORMAT);
            Collection<CSTemplateInfo> templateInfos = templates.values();
            ArrayList<CSTemplateInfo> templateInfoList = new ArrayList<CSTemplateInfo>(templateInfos);
            Collections.sort(templateInfoList, new TemplateCompare());
            for (CSTemplateInfo info : templateInfoList) {
                String projectInfo = String.format("%-20s %s", info.getTizenVersion(), info.getTemplateTitle());
                this.progressLog.info(projectInfo);
            }
        } else {
            this.progressLog.error("Not Found CS templates");
            throw new UnexpectedException(2, "Not Found CS templates");
        }
        return list;
    }
}

