/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.migrate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.migrate.MigrationData;
import org.tizen.ncli.subcommands.migrate.PackagesConfigParser;
import org.tizen.ncli.subcommands.migrate.ProjectJsonParser;
import org.tizen.ncli.util.DotnetUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MigrateCSProjectCommand
extends AbstractSubCommand<MigrateCSProjectCommand> {
    public static final String DEFAULT_XAMARIN_VERSION = "2.3.4.214-pre5";
    public static final String TARGET_FRAMEWORK_EXE_PREFIX = "netcoreapp";
    public static final String TARGET_FRAMEWORK_LIB_PREFIX = "netstandard";
    public static final String TARGET_FRAMEWORK_NETCOREAPP10 = "netcoreapp1.0";
    public static final String TARGET_FRAMEWORK_NETCOREAPP11 = "netcoreapp1.1";
    public static final String TARGET_FRAMEWORK_NETCOREAPP20 = "netcoreapp2.0";
    public static final String TARGET_FRAMEWORK_NETSTANDARD16 = "netstandard1.6";
    private static final String NETSTANDARD_LIBRARY_PACKAGE = "netstandard.library";
    private static final String NETCORE_APP_PACKAGE = "microsoft.netcore.app";
    private static final String MICROSOFT_NET_SDK_PACKAGE = "microsoft.net.sdk";
    private Node projectNode = null;

    @Override
    protected MigrateCSProjectCommand call() {
        String workingPath = this.workingDir.toString();
        String workingTargetFilePath = DotnetUtil.getWorkingTarget(workingPath);
        if (workingTargetFilePath == null) {
            this.progressLog.error("Migrate failed : There is no solution or project file.");
            return null;
        }
        if (workingTargetFilePath.isEmpty()) {
            this.progressLog.error("Migrate failed : There is multiple solution or project files.");
            this.progressLog.error("Please specify which solution or project file to use.");
            return null;
        }
        Set<String> csprojTargets = DotnetUtil.getCSProjectsFromTarget(workingTargetFilePath);
        if (csprojTargets != null && !csprojTargets.isEmpty()) {
            for (String csproj : csprojTargets) {
                this.convertProjectFile(csproj);
            }
        } else {
            this.progressLog.error("Migrate failed : There is no project to migrate or some problem occurred.");
            return null;
        }
        return null;
    }

    protected boolean convertProjectFile(String projectFile) {
        String pconfigPath;
        File csprojFile = new File(projectFile);
        if (!csprojFile.exists()) {
            this.progressLog.error("ERROR : there is no csproj file ({})", (Object)projectFile);
            return false;
        }
        this.progressLog.info("converting project {} ...", (Object)projectFile);
        Document doc = XMLUtil.readXML((File)csprojFile);
        this.projectNode = XMLUtil.getDOMNodeT((Document)doc, (String[])new String[]{"Project"});
        if (this.projectNode == null) {
            this.progressLog.error("there is no 'Project' node in csproj.");
            return false;
        }
        if (this.isConverted(doc)) {
            this.progressLog.info("project is already converted! : {}", (Object)projectFile);
            return false;
        }
        boolean isTizenProject = DotnetUtil.isTizenProject(csprojFile);
        MigrationData data = new MigrationData();
        boolean bExistManifest = DotnetUtil.existTizenManifest(csprojFile);
        String jsonPath = DotnetUtil.getJsonPath(csprojFile);
        if (jsonPath != null) {
            this.progressLog.info("  parsing project json file {} ...", (Object)jsonPath);
            if (!ProjectJsonParser.parse(jsonPath, data)) {
                this.progressLog.error("  ERROR : failed to parse project json file!");
                return false;
            }
        } else {
            this.progressLog.info("  there is no json file");
        }
        if ((pconfigPath = DotnetUtil.getPackagesConfigPath(csprojFile)) != null) {
            this.progressLog.info("  parsing packages.config file {} ...", (Object)pconfigPath);
            if (!PackagesConfigParser.parse(pconfigPath, data)) {
                this.progressLog.error("  ERROR : failed to parse packages.config file!");
                return false;
            }
        } else {
            this.progressLog.info("  there is no packages.config file");
        }
        this.progressLog.info("  converting project tag ...");
        this.convertProjectTag(doc);
        this.progressLog.info("  converting property group ...");
        boolean ret = this.convertPropertyGroup(doc, data);
        if (!ret) {
            this.progressLog.error("  ERROR : Invalid project type to convert.");
            return false;
        }
        this.progressLog.info("  converting item group ...");
        this.convertItemGroup(doc, isTizenProject, data);
        this.progressLog.info("  converting imports ...");
        this.convertImport(doc, isTizenProject, data);
        this.progressLog.info("  converting target error task ...");
        this.convertTargetErrorTask(doc, isTizenProject);
        this.progressLog.info("  adding Tizen .NET CPS elements ...");
        this.addCPSElements(doc, bExistManifest);
        this.progressLog.info("  writing csproj ...");
        XMLUtil.writeToFile((Document)doc, (String)projectFile);
        this.progressLog.info("Completed conversion of {}", (Object)projectFile);
        return true;
    }

    private boolean isConverted(Document doc) {
        String sdk = ((Element)this.projectNode).getAttribute("Sdk");
        if (sdk.compareToIgnoreCase("Microsoft.NET.Sdk") == 0 || sdk.compareToIgnoreCase("Tizen.NET.Sdk") == 0) {
            return true;
        }
        NodeList importNodes = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "Import"});
        if (importNodes == null) {
            return false;
        }
        Node node = null;
        for (int i = 0; i < importNodes.getLength(); ++i) {
            node = importNodes.item(i);
            if (!node.hasAttributes() || (sdk = ((Element)node).getAttribute("Sdk")).compareToIgnoreCase("Microsoft.NET.Sdk") != 0) continue;
            return true;
        }
        return false;
    }

    protected void addCPSElements(Document doc, boolean bExistTizenManifest) {
        Node firstChild = this.projectNode.getFirstChild();
        this.addImportProject(doc, "Sdk.props", "Microsoft.NET.Sdk", firstChild);
        this.addPropertyGroupGlobal(doc, firstChild);
        this.addImportConditionalProject(doc, "props", firstChild);
        this.addTizenPackageCondition(doc);
        if (bExistTizenManifest) {
            this.addTizenNETSdkReference(doc);
        }
        this.addImportProject(doc, "Sdk.targets", "Microsoft.NET.Sdk", null);
        this.addImportConditionalProject(doc, "targets", null);
    }

    private void addTizenNETSdkReference(Document doc) {
        NodeList items = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "ItemGroup"});
        Node parentNode = items == null ? this.createChildNode(doc, "ItemGroup", null, this.projectNode) : items.item(items.getLength() - 1);
        Element newPackageReference = this.createChildNode(doc, "PackageReference", null, parentNode);
        newPackageReference.setAttribute("Include", "Tizen.NET.Sdk");
        newPackageReference.setAttribute("Version", "0.9.16-pre1");
    }

    private void addTizenPackageCondition(Document doc) {
        NodeList props = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "PropertyGroup"});
        Node node = null;
        for (int i = 0; i < props.getLength(); ++i) {
            if (props.item(i).getAttributes().getLength() != 0) continue;
            node = props.item(i);
        }
        String outputType = XMLUtil.getDOMValueT((Document)doc, (String[])new String[]{"Project", "PropertyGroup", "OutputType"});
        if (outputType == null || !outputType.equals("Exe")) {
            return;
        }
        if (node == null) {
            Element newPropertyGroup = this.createChildNode(doc, "PropertyGroup", null, this.projectNode);
            this.createChildNode(doc, "TizenCreateTpkOnBuild", "true", newPropertyGroup);
        } else {
            this.createChildNode(doc, "TizenCreateTpkOnBuild", "true", node);
        }
    }

    private void addImportConditionalProject(Document doc, String type, Node beforeNode) {
        Element propsImport = this.createChildNode(doc, "Import", null, this.projectNode, beforeNode);
        propsImport.setAttribute("Condition", "Exists('$(TizenProjectExtensionsPath)Tizen.NET.ProjectType." + type + "')");
        propsImport.setAttribute("Project", "$(TizenProjectExtensionsPath)Tizen.NET.ProjectType." + type);
    }

    private void addPropertyGroupGlobal(Document doc, Node beforeNode) {
        Element globalPropertyGroup = this.createChildNode(doc, "PropertyGroup", null, this.projectNode, beforeNode);
        globalPropertyGroup.setAttribute("Label", "Globals");
        this.createChildNode(doc, "TizenProjectExtensionsPath", "$(MSBuildExtensionsPath)\\Tizen\\VisualStudio\\", globalPropertyGroup);
    }

    private void addImportProject(Document doc, String projectName, String projectSdk, Node beforeNode) {
        Element propsImport = this.createChildNode(doc, "Import", null, this.projectNode, beforeNode);
        propsImport.setAttribute("Project", projectName);
        propsImport.setAttribute("Sdk", projectSdk);
    }

    protected Node convertProjectTag(Document doc) {
        NamedNodeMap attrs = this.projectNode.getAttributes();
        while (attrs.getLength() > 0) {
            ((Element)this.projectNode).removeAttribute(attrs.item(0).getNodeName());
        }
        return this.projectNode;
    }

    protected boolean convertPropertyGroup(Document doc, MigrationData data) {
        boolean addProp = false;
        NodeList props = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "PropertyGroup"});
        for (int i = 0; i < props.getLength(); ++i) {
            if (props.item(i).getAttributes().getLength() != 0) continue;
            addProp = this.convertPropertyGroupCommon(doc, props.item(i), addProp, data);
        }
        Element newPropertyGroup = this.createChildNode(doc, "PropertyGroup", null, this.projectNode);
        this.createChildNode(doc, "GenerateAssemblyTitleAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyDescriptionAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyConfigurationAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyCompanyAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyProductAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyCopyrightAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyVersionAttribute", "false", newPropertyGroup);
        this.createChildNode(doc, "GenerateAssemblyFileVersionAttribute", "false", newPropertyGroup);
        return addProp;
    }

    private boolean convertPropertyGroupCommon(Document doc, Node group, boolean addProp, MigrationData data) {
        boolean findProp = false;
        boolean isDNXCore = false;
        String nugetTargetMoniker = null;
        NodeList children = group.getChildNodes();
        for (int k = 0; k < children.getLength(); ++k) {
            Node child = children.item(k);
            String nodename = child.getNodeName();
            if (nodename.equals("TargetFramework") || nodename.equals("TargetFrameworks")) {
                findProp = true;
                group.removeChild(child);
                --k;
                continue;
            }
            if (nodename.equals("NuGetTargetMoniker")) {
                nugetTargetMoniker = child.getFirstChild().getNodeValue();
                findProp = true;
                group.removeChild(child);
                --k;
                continue;
            }
            if (nodename.equals("TargetFrameworkIdentifier")) {
                String id = child.getFirstChild().getNodeValue();
                if (id.toLowerCase().contains("dnxcore")) {
                    isDNXCore = true;
                }
                findProp = true;
                group.removeChild(child);
                --k;
                continue;
            }
            if (!nodename.equals("TargetFrameworkProfile") && !nodename.equals("TargetFrameworkVersion") && !nodename.equals("EnableDefaultCompileItems") && !nodename.equals("EnableDefaultEmbeddedResourceItems") && !nodename.equals("PackageTargetFallback")) continue;
            findProp = true;
            group.removeChild(child);
            --k;
        }
        if (findProp && !addProp) {
            this.addTargetFramework(doc, group, nugetTargetMoniker, isDNXCore, data);
            this.createChildNode(doc, "EnableDefaultCompileItems", "false", group);
            this.createChildNode(doc, "EnableDefaultEmbeddedResourceItems", "false", group);
            addProp = true;
        }
        return addProp;
    }

    private void addTargetFramework(Document doc, Node group, String nugetTargetMoniker, boolean isDNXCore, MigrationData data) {
        String target = data.getTargetFrameworkString();
        if (target == null) {
            String lowerMoniker;
            target = TARGET_FRAMEWORK_NETSTANDARD16;
            if (nugetTargetMoniker != null && (lowerMoniker = nugetTargetMoniker.toLowerCase()).contains(TARGET_FRAMEWORK_EXE_PREFIX)) {
                int pos = lowerMoniker.indexOf("version=");
                String version = "v1.0";
                if (pos >= 0) {
                    version = lowerMoniker.substring(pos + 8);
                }
                target = version.equals("v1.0") ? TARGET_FRAMEWORK_NETCOREAPP10 : (version.equals("v1.1") ? TARGET_FRAMEWORK_NETCOREAPP11 : (version.equals("v2.0") ? TARGET_FRAMEWORK_NETCOREAPP20 : TARGET_FRAMEWORK_NETCOREAPP10));
            }
            this.createChildNode(doc, "TargetFramework", target, group);
        } else if (target.indexOf(59) > 0) {
            this.createChildNode(doc, "TargetFrameworks", target, group);
        } else {
            this.createChildNode(doc, "TargetFramework", target, group);
        }
        String ptf = data.getPackageTargetFallbackString();
        if (ptf == null) {
            if (isDNXCore) {
                this.createChildNode(doc, "PackageTargetFallback", "$(PackageTargetFallback);portable-net45+win8;dnxcore50", group);
            } else {
                this.createChildNode(doc, "PackageTargetFallback", "$(PackageTargetFallback);portable-net45+win8+wpa81+wp8", group);
            }
        } else {
            this.createChildNode(doc, "PackageTargetFallback", "$(PackageTargetFallback);" + ptf, group);
        }
    }

    protected void convertItemGroup(Document doc, boolean isTizenProject, MigrationData data) {
        boolean addPkgRef = false;
        ArrayList<String> pkgs = new ArrayList<String>();
        NodeList items = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "ItemGroup"});
        for (int i = 0; i < items.getLength(); ++i) {
            boolean findPkgRef = false;
            NodeList children = items.item(i).getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node child = children.item(k);
                String nodename = child.getNodeName();
                if (!nodename.equals("PackageReference")) continue;
                findPkgRef = true;
                String pkgname = ((Element)child).getAttribute("Include").toLowerCase();
                if (pkgname.equals(NETSTANDARD_LIBRARY_PACKAGE) || pkgname.equals(NETCORE_APP_PACKAGE) || pkgname.equals(MICROSOFT_NET_SDK_PACKAGE)) {
                    items.item(i).removeChild(child);
                    --k;
                    continue;
                }
                pkgs.add(((Element)child).getAttribute("Include"));
            }
            if (findPkgRef && !addPkgRef) {
                this.addPackageReference(doc, items.item(i), isTizenProject, data, pkgs);
                addPkgRef = true;
                continue;
            }
            if (children.getLength() != 0) continue;
            Node ig = items.item(i);
            Node parent = ig.getParentNode();
            parent.removeChild(ig);
        }
        if (!addPkgRef) {
            this.addPackageReference(doc, null, isTizenProject, data, pkgs);
        }
    }

    protected void convertImport(Document doc, boolean isTizenProject, MigrationData data) {
        NodeList items = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "Import"});
        for (int i = 0; i < items.getLength(); ++i) {
            Node parent;
            Element node = (Element)items.item(i);
            String proj = node.getAttribute("Project").toLowerCase();
            if (proj.contains("microsoft.portable.csharp.targets") || proj.contains("microsoft.csharp.targets") || proj.contains("microsoft.common.props")) {
                parent = node.getParentNode();
                parent.removeChild(node);
                continue;
            }
            if (!proj.contains("xamarin.forms") || proj.contains("xamarin.forms.platform.tizen")) continue;
            parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    protected void convertTargetErrorTask(Document doc, boolean isTizenProject) {
        NodeList items = XMLUtil.getDOMNodesT((Document)doc, (String[])new String[]{"Project", "Target"});
        block0: for (int i = 0; i < items.getLength(); ++i) {
            Element node = (Element)items.item(i);
            NodeList children = node.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node child = children.item(k);
                String nodename = child.getNodeName();
                if (!nodename.equals("Error")) continue;
                Node parent = node.getParentNode();
                parent.removeChild(node);
                continue block0;
            }
        }
    }

    protected void renameNamespaceRecursive(Document doc, Node node, String namespace) {
        if (node.getNodeType() == 1) {
            doc.renameNode(node, namespace, node.getNodeName());
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.renameNamespaceRecursive(doc, list.item(i), namespace);
        }
    }

    private void addPackageReference(Document doc, Node itemgroup, boolean isTizenProject, MigrationData data, List<String> pkgs) {
        if (itemgroup == null) {
            itemgroup = this.createChildNode(doc, "ItemGroup", null, this.projectNode);
        }
        if (data.getPackages() != null) {
            Map<String, String> depMap = data.getPackages();
            for (Map.Entry<String, String> entry : depMap.entrySet()) {
                String pkgname = entry.getKey().toLowerCase();
                if (pkgname.equals(NETSTANDARD_LIBRARY_PACKAGE) || pkgname.equals(NETCORE_APP_PACKAGE) || pkgname.equals(MICROSOFT_NET_SDK_PACKAGE)) continue;
                this.addPackageReferenceInternal(doc, itemgroup, pkgs, entry.getKey(), entry.getValue());
            }
        }
    }

    private void addPackageReferenceInternal(Document doc, Node itemgroup, List<String> pkgs, String name, String version) {
        for (String pkg : pkgs) {
            if (pkg.compareToIgnoreCase(name) != 0) continue;
            return;
        }
        Element pkgref = this.createChildNode(doc, "PackageReference", null, itemgroup);
        pkgref.setAttribute("Include", name);
        pkgref.setAttribute("Version", version);
        this.createChildNode(doc, "ExcludeAssets", "Build", pkgref);
        pkgs.add(name);
    }

    private Element createChildNode(Document doc, String tag, String value, Node parent) {
        return this.createChildNode(doc, tag, value, parent, null);
    }

    private Element createChildNode(Document doc, String tag, String value, Node parent, Node beforeNode) {
        Element child = doc.createElement(tag);
        if (value != null) {
            child.appendChild(doc.createTextNode(value));
        }
        if (beforeNode == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, beforeNode);
        }
        return child;
    }
}

