/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.SdbAppCmdAPI;
import org.tizen.ncli.subcommands.target.Uninstall;
import org.tizen.ncli.subcommands.tv.TVSdbCmdSelector;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class UninstallCLICommand
extends AbstractSubCommand<Uninstall> {
    private IDevice target = null;
    private String pkgid = null;
    private String uninstallCommand = TizenPlatformConstants.PKG_TOOL + " -q -u -n %s";
    private String removableCommand = TizenPlatformConstants.PKG_TOOL_ROAPP_CHECK_COMMAND;
    private String isRemovable = TizenPlatformConstants.RWAPP_RESULT;
    private String isUnremovable = TizenPlatformConstants.ROAPP_RESULT;
    private String version = null;
    private String arch = null;
    private float sdbPluginVersion = 0.0f;
    String sdbPluginVer = null;
    public PlatformCapability platformCapabilityChecker = null;

    @Override
    protected Uninstall call() {
        Uninstall result;
        block10: {
            result = new Uninstall();
            if (this.target == null) {
                this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
                throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_TARGET);
            }
            if (this.pkgid == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
                throw new UnexpectedException(2, NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
            }
            SdbAppCmdAPI acapi = new SdbAppCmdAPI(this.target);
            if (acapi.isAvailable()) {
                MultiLineReceiver mlReceiver = new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        for (String line : lines) {
                            line = line.trim();
                            UninstallCLICommand.this.log.info(line);
                            UninstallCLICommand.this.progressLog.info(line);
                        }
                    }
                };
                try {
                    if (!acapi.uninstallPackage(this.pkgid, (IShellOutputReceiver)mlReceiver)) {
                        this.progressLog.info(TizenCLIMessages.UNINST_FAIL_PACKAGE);
                        return null;
                    }
                    break block10;
                }
                catch (IOException e) {
                    this.progressLog.info(TizenCLIMessages.UNINST_FAIL_PACKAGE);
                    return null;
                }
            }
            TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
            if (tvSdbCmdSelector.isAppID(this.pkgid) && tvSdbCmdSelector.isSTV()) {
                this.uninstallPackage();
            } else if (this.isRemovablePackage()) {
                this.uninstallPackage();
            } else {
                this.progressLog.info(TizenCLIMessages.UNINST_FAIL_INVALID_PACKAGE);
                throw new UnexpectedException(2, TizenCLIMessages.UNINST_FAIL_INVALID_PACKAGE);
            }
        }
        return result;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
    }

    public void setPkgid(String pkgid) {
        this.pkgid = pkgid;
        this.log.debug("[pkgid]: " + (pkgid == null ? "null" : pkgid));
    }

    private boolean isRemovablePackage() {
        this.log.debug("=check removable package=");
        boolean result = false;
        String returnResult = null;
        if (this.target.isSecureProtocol()) {
            this.removableCommand = TizenPlatformConstants.PKG_TOOL_ROAPP_CHECK_COMMAND;
        }
        String removableCmd = String.format(this.removableCommand, this.pkgid);
        this.log.debug("[check removable command]: " + removableCmd);
        returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, removableCmd);
        if (returnResult == null) {
            this.log.debug("removable check failed: " + removableCmd);
        } else if (returnResult.contains(this.isRemovable)) {
            result = true;
        } else if (returnResult.contains(this.isUnremovable)) {
            this.progressLog.info(TizenCLIMessages.UNINST_UNREMOVABLE_PACKAGE);
        } else {
            this.progressLog.info(TizenCLIMessages.UNINST_UNEXIST_PACKAGE);
        }
        return result;
    }

    private String uninstallPackage() {
        String originalpkgid;
        this.log.debug("=uninstall package=");
        String result = null;
        boolean validsdbPluginVersion = true;
        TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
        try {
            this.platformCapabilityChecker = this.target.getPlatformCapability();
        }
        catch (Exception e) {
            this.log.debug("getPlatformCapability failed");
            validsdbPluginVersion = false;
        }
        if (validsdbPluginVersion) {
            this.version = this.platformCapabilityChecker.getPlatformVersion();
            this.arch = this.platformCapabilityChecker.getCpuArch();
            this.sdbPluginVer = this.platformCapabilityChecker.getSdbdPluginVersion().substring(0, 3);
            if (!this.sdbPluginVer.equals("unknown".substring(0, 3))) {
                this.sdbPluginVersion = Float.valueOf(this.sdbPluginVer).floatValue();
            }
        }
        if (this.target.isSecureProtocol()) {
            if (tvSdbCmdSelector.isAppID(this.pkgid) && tvSdbCmdSelector.isSTV()) {
                this.uninstallCommand = this.getTVUnInstallCmd();
                originalpkgid = this.pkgid;
                this.pkgid = this.getTVWASAppID(this.pkgid);
                try {
                    if (validsdbPluginVersion && !this.sdbPluginVer.equals("unknown".substring(0, 3)) && ((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.pkgid != null && this.version.startsWith("4.0") && this.arch.contains("armv7")) {
                        this.pkgid = originalpkgid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.uninstallCommand = "appuninstall %s";
            }
        } else if (tvSdbCmdSelector.isAppID(this.pkgid) && tvSdbCmdSelector.isSTV()) {
            this.uninstallCommand = this.getTVUnInstallCmd();
            originalpkgid = this.pkgid;
            this.pkgid = this.getTVWASAppID(this.pkgid);
            try {
                if (validsdbPluginVersion && !this.sdbPluginVer.equals("unknown".substring(0, 3)) && ((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.pkgid != null && this.version.startsWith("4.0") && this.arch.contains("armv7")) {
                    this.pkgid = originalpkgid;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.pkgid == null || this.pkgid.isEmpty()) {
            this.progressLog.error("Package ID is not valid. Please check the package ID again.");
            return null;
        }
        String uninstallCmd = String.format(this.uninstallCommand, this.pkgid);
        this.log.debug("[Uninstall Command]]: " + uninstallCmd);
        result = TargetUtil.getDefault().returnExecuteCommand(this.target, uninstallCmd);
        this.log.info(result);
        this.progressLog.info("--------------------");
        this.progressLog.info("Platform log view");
        this.progressLog.info("--------------------");
        this.progressLog.info(result);
        return result;
    }

    private String getTVUnInstallCmd() {
        String cmd;
        String tvUnInstallCmd = "";
        TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
        tvUnInstallCmd = cmd = tvSdbCmdSelector.getCmd("TV_UNINSTALL_COMMAND", null);
        return tvUnInstallCmd;
    }

    private String getTVWASAppID(String targetTizenAppID) {
        String tvWASAppID = "";
        String result = "";
        TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
        String tvAppListcmd = tvSdbCmdSelector.getCmd("TV_APPLIST_COMMAND", null);
        result = TargetUtil.getDefault().returnExecuteCommand(this.target, tvAppListcmd);
        if (result == null) {
            return null;
        }
        String delim = System.getProperty("line.separator");
        String[] lines = StringUtil.split((String)result, (String)delim);
        if (this.version != null && this.version.startsWith("2.4")) {
            String regx = "(.*)( )(.*)";
            Pattern pattern = Pattern.compile(regx);
            for (String cont : lines) {
                Matcher matcher = pattern.matcher(cont);
                String value = "";
                while (matcher.find()) {
                    value = matcher.group(3).trim();
                    if (!value.equals(targetTizenAppID)) continue;
                    return value;
                }
            }
        }
        String wasAppID = "";
        String tizenAppID = "";
        int matcherFindNumber = 0;
        String regx = "(app_id|app_tizen_id|tizen_id)(.*)=(.*)";
        Pattern pattern = Pattern.compile(regx);
        for (String cont : lines) {
            Matcher matcher = pattern.matcher(cont);
            String value = "";
            while (matcher.find()) {
                value = matcher.group(3).replaceAll("-", "").trim();
                switch (++matcherFindNumber) {
                    case 1: {
                        wasAppID = value;
                        break;
                    }
                    case 2: {
                        tizenAppID = value;
                    }
                }
            }
            if (matcherFindNumber != 2) continue;
            matcherFindNumber = 0;
            if (!tizenAppID.equals(targetTizenAppID) && !wasAppID.equals(targetTizenAppID)) continue;
            tvWASAppID = wasAppID;
            break;
        }
        return tvWASAppID;
    }
}

