/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.validate;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ManifestSchemaValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String VALIDATION_SCHEMAS_DIR = "tools" + File.separator + "ide" + File.separator + "resources" + File.separator + "common" + File.separator + "schema";

    public boolean isValidDocument(File manifestFile, String schemaFileName) throws SAXParseException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String sdkPath = InstallPathConfig.getSDKPath();
        File schemaFile = new File(sdkPath + File.separator + VALIDATION_SCHEMAS_DIR + File.separator + schemaFileName);
        if (schemaFile.exists()) {
            StreamSource source = new StreamSource(manifestFile);
            this.logger.info(manifestFile.getAbsolutePath());
            this.logger.info(schemaFile.getAbsolutePath());
            try {
                Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(source);
                return true;
            }
            catch (IOException | SAXException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

