/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfCell
extends Cell
implements RtfExtendedElement {
    private static final int MERGE_NONE = 0;
    private static final int MERGE_VERT_PARENT = 1;
    private static final int MERGE_VERT_CHILD = 2;
    private RtfRow parentRow = null;
    private ArrayList content = null;
    private int cellRight = 0;
    private int cellWidth = 0;
    private RtfBorderGroup borders = null;
    private RtfColor backgroundColor = null;
    private int cellPadding = 0;
    private int mergeType = 0;
    private RtfDocument document = null;
    private boolean inHeader = false;
    private boolean deleted = false;
    private boolean usePadding = false;
    private float cellPaddingLeft = 0.0f;
    private float cellPaddingTop = 0.0f;
    private float cellPaddingBottom = 0.0f;
    private float cellPaddingRight = 0.0f;

    public RtfCell() {
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(String string) {
        super(string);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(Element element) throws BadElementException {
        super(element);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    protected RtfCell(boolean bl) {
        this.deleted = bl;
        this.verticalAlignment = 5;
    }

    protected RtfCell(RtfDocument rtfDocument, RtfRow rtfRow, Cell cell) {
        this.document = rtfDocument;
        this.parentRow = rtfRow;
        this.importCell(cell);
    }

    protected RtfCell(RtfDocument rtfDocument, RtfRow rtfRow, PdfPCell pdfPCell) {
        this.document = rtfDocument;
        this.parentRow = rtfRow;
        this.importCell(pdfPCell);
    }

    private void importCell(Cell cell) {
        RtfBasicElement[] rtfBasicElementArray;
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.colspan = cell.getColspan();
        this.rowspan = cell.getRowspan();
        if (cell.getRowspan() > 1) {
            this.mergeType = 1;
        }
        this.borders = cell instanceof RtfCell ? new RtfBorderGroup(this.document, 2, ((RtfCell)cell).getBorders()) : new RtfBorderGroup(this.document, 2, cell.getBorder(), cell.getBorderWidth(), cell.getBorderColor());
        this.verticalAlignment = cell.getVerticalAlignment();
        this.backgroundColor = cell.getBackgroundColor() == null ? new RtfColor(this.document, 255, 255, 255) : new RtfColor(this.document, cell.getBackgroundColor());
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        Iterator iterator = cell.getElements();
        Paragraph paragraph = null;
        while (iterator.hasNext()) {
            try {
                int n;
                RtfBasicElement[] rtfBasicElementArray2;
                rtfBasicElementArray = (RtfBasicElement[])iterator.next();
                if (!(rtfBasicElementArray instanceof Paragraph) && !(rtfBasicElementArray instanceof List)) {
                    if (paragraph != null) {
                        paragraph.add(rtfBasicElementArray);
                        continue;
                    }
                    paragraph = new Paragraph();
                    paragraph.setAlignment(cell.getHorizontalAlignment());
                    paragraph.add(rtfBasicElementArray);
                    continue;
                }
                if (paragraph != null) {
                    rtfBasicElementArray2 = this.document.getMapper().mapElement(paragraph);
                    for (n = 0; n < rtfBasicElementArray2.length; ++n) {
                        rtfBasicElementArray2[n].setInTable(true);
                        this.content.add(rtfBasicElementArray2[n]);
                    }
                    paragraph = null;
                }
                if (rtfBasicElementArray instanceof Paragraph && ((Paragraph)rtfBasicElementArray).getAlignment() == -1) {
                    ((Paragraph)rtfBasicElementArray).setAlignment(cell.getHorizontalAlignment());
                }
                rtfBasicElementArray2 = this.document.getMapper().mapElement((Element)rtfBasicElementArray);
                for (n = 0; n < rtfBasicElementArray2.length; ++n) {
                    rtfBasicElementArray2[n].setInTable(true);
                    this.content.add(rtfBasicElementArray2[n]);
                }
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if (paragraph != null) {
            try {
                rtfBasicElementArray = this.document.getMapper().mapElement(paragraph);
                for (int i = 0; i < rtfBasicElementArray.length; ++i) {
                    rtfBasicElementArray[i].setInTable(true);
                    this.content.add(rtfBasicElementArray[i]);
                }
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
    }

    private void importCell(PdfPCell pdfPCell) {
        PdfPTable pdfPTable;
        Object object;
        Object object2;
        this.content = new ArrayList();
        if (pdfPCell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        this.cellPaddingBottom = pdfPCell.getPaddingBottom();
        this.cellPaddingTop = pdfPCell.getPaddingTop();
        this.cellPaddingRight = pdfPCell.getPaddingRight();
        this.cellPaddingLeft = pdfPCell.getPaddingLeft();
        this.borders = new RtfBorderGroup(this.document, 2, pdfPCell.getBorder(), pdfPCell.getBorderWidth(), pdfPCell.getBorderColor());
        this.border = pdfPCell.getBorder();
        this.borderColor = pdfPCell.getBorderColor();
        this.borderColorBottom = pdfPCell.getBorderColorBottom();
        this.borderColorTop = pdfPCell.getBorderColorTop();
        this.borderColorLeft = pdfPCell.getBorderColorLeft();
        this.borderColorRight = pdfPCell.getBorderColorRight();
        this.borderWidth = pdfPCell.getBorderWidth();
        this.borderWidthBottom = pdfPCell.getBorderWidthBottom();
        this.borderWidthTop = pdfPCell.getBorderWidthTop();
        this.borderWidthLeft = pdfPCell.getBorderWidthLeft();
        this.borderWidthRight = pdfPCell.getBorderWidthRight();
        this.colspan = pdfPCell.getColspan();
        this.rowspan = 1;
        this.verticalAlignment = pdfPCell.getVerticalAlignment();
        this.backgroundColor = pdfPCell.getBackgroundColor() == null ? new RtfColor(this.document, 255, 255, 255) : new RtfColor(this.document, pdfPCell.getBackgroundColor());
        java.util.List list = pdfPCell.getCompositeElements();
        if (list != null) {
            RtfBasicElement[] rtfBasicElementArray;
            object2 = list.iterator();
            object = null;
            while (object2.hasNext()) {
                try {
                    int n;
                    RtfBasicElement[] rtfBasicElementArray2;
                    rtfBasicElementArray = (RtfBasicElement[])object2.next();
                    if (!(rtfBasicElementArray instanceof Paragraph) && !(rtfBasicElementArray instanceof List)) {
                        if (object != null) {
                            ((Paragraph)object).add(rtfBasicElementArray);
                            continue;
                        }
                        object = new Paragraph();
                        ((Paragraph)object).setAlignment(pdfPCell.getHorizontalAlignment());
                        ((Paragraph)object).add(rtfBasicElementArray);
                        continue;
                    }
                    if (object != null) {
                        rtfBasicElementArray2 = this.document.getMapper().mapElement((Element)object);
                        for (n = 0; n < rtfBasicElementArray2.length; ++n) {
                            rtfBasicElementArray2[n].setInTable(true);
                            this.content.add(rtfBasicElementArray2[n]);
                        }
                        object = null;
                    }
                    if (rtfBasicElementArray instanceof Paragraph && ((Paragraph)rtfBasicElementArray).getAlignment() == -1) {
                        ((Paragraph)rtfBasicElementArray).setAlignment(pdfPCell.getHorizontalAlignment());
                    }
                    rtfBasicElementArray2 = this.document.getMapper().mapElement((Element)rtfBasicElementArray);
                    for (n = 0; n < rtfBasicElementArray2.length; ++n) {
                        rtfBasicElementArray2[n].setInTable(true);
                        this.content.add(rtfBasicElementArray2[n]);
                    }
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
            if (object != null) {
                try {
                    rtfBasicElementArray = this.document.getMapper().mapElement((Element)object);
                    for (int i = 0; i < rtfBasicElementArray.length; ++i) {
                        rtfBasicElementArray[i].setInTable(true);
                        this.content.add(rtfBasicElementArray[i]);
                    }
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
        }
        if ((object2 = pdfPCell.getImage()) != null) {
            try {
                object = this.document.getMapper().mapElement((Element)object2);
                for (int i = 0; i < ((RtfBasicElement[])object).length; ++i) {
                    object[i].setInTable(true);
                    this.content.add(object[i]);
                }
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if ((object = pdfPCell.getPhrase()) != null) {
            try {
                RtfBasicElement[] rtfBasicElementArray = this.document.getMapper().mapElement((Element)object);
                for (int i = 0; i < rtfBasicElementArray.length; ++i) {
                    rtfBasicElementArray[i].setInTable(true);
                    this.content.add(rtfBasicElementArray[i]);
                }
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if ((pdfPTable = pdfPCell.getTable()) != null) {
            this.add(pdfPTable);
        }
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        if (this.mergeType == 1) {
            outputStream.write(DocWriter.getISOBytes("\\clvmgf"));
        } else if (this.mergeType == 2) {
            outputStream.write(DocWriter.getISOBytes("\\clvmrg"));
        }
        switch (this.verticalAlignment) {
            case 6: {
                outputStream.write(DocWriter.getISOBytes("\\clvertalb"));
                break;
            }
            case 1: 
            case 5: {
                outputStream.write(DocWriter.getISOBytes("\\clvertalc"));
                break;
            }
            case 4: {
                outputStream.write(DocWriter.getISOBytes("\\clvertalt"));
            }
        }
        this.borders.writeContent(outputStream);
        if (this.backgroundColor != null) {
            outputStream.write(DocWriter.getISOBytes("\\clcbpat"));
            outputStream.write(this.intToByteArray(this.backgroundColor.getColorNumber()));
        }
        this.document.outputDebugLinebreak(outputStream);
        outputStream.write(DocWriter.getISOBytes("\\clftsWidth3"));
        this.document.outputDebugLinebreak(outputStream);
        outputStream.write(DocWriter.getISOBytes("\\clwWidth"));
        outputStream.write(this.intToByteArray(this.cellWidth));
        this.document.outputDebugLinebreak(outputStream);
        if (this.cellPadding > 0) {
            outputStream.write(DocWriter.getISOBytes("\\clpadl"));
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write(DocWriter.getISOBytes("\\clpadt"));
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write(DocWriter.getISOBytes("\\clpadr"));
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write(DocWriter.getISOBytes("\\clpadb"));
            outputStream.write(this.intToByteArray(this.cellPadding / 2));
            outputStream.write(DocWriter.getISOBytes("\\clpadfl3"));
            outputStream.write(DocWriter.getISOBytes("\\clpadft3"));
            outputStream.write(DocWriter.getISOBytes("\\clpadfr3"));
            outputStream.write(DocWriter.getISOBytes("\\clpadfb3"));
        }
        outputStream.write(DocWriter.getISOBytes("\\cellx"));
        outputStream.write(this.intToByteArray(this.cellRight));
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.content.size() == 0) {
            outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.parentRow.getParentTable().getTableFitToPage()) {
                outputStream.write(RtfParagraphStyle.KEEP_TOGETHER_WITH_NEXT);
            }
            outputStream.write(RtfParagraph.IN_TABLE);
        } else {
            for (int i = 0; i < this.content.size(); ++i) {
                RtfBasicElement rtfBasicElement = (RtfBasicElement)this.content.get(i);
                if (rtfBasicElement instanceof RtfParagraph) {
                    ((RtfParagraph)rtfBasicElement).setKeepTogetherWithNext(this.parentRow.getParentTable().getTableFitToPage());
                }
                rtfBasicElement.writeContent(outputStream);
                if (!(rtfBasicElement instanceof RtfParagraph) || i >= this.content.size() - 1) continue;
                outputStream.write(RtfParagraph.PARAGRAPH);
            }
        }
        outputStream.write(DocWriter.getISOBytes("\\cell"));
    }

    protected void setCellRight(int n) {
        this.cellRight = n;
    }

    protected int getCellRight() {
        return this.cellRight;
    }

    protected void setCellWidth(int n) {
        this.cellWidth = n;
    }

    protected int getCellWidth() {
        return this.cellWidth;
    }

    protected int getCellpadding() {
        return this.cellPadding;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    public void setBorders(RtfBorderGroup rtfBorderGroup) {
        this.borders = new RtfBorderGroup(this.document, 2, rtfBorderGroup);
    }

    protected RtfColor getRtfBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setCellMergeChild(RtfCell rtfCell) {
        this.mergeType = 2;
        this.cellWidth = rtfCell.getCellWidth();
        this.cellRight = rtfCell.getCellRight();
        this.cellPadding = rtfCell.getCellpadding();
        this.borders = rtfCell.getBorders();
        this.verticalAlignment = rtfCell.getVerticalAlignment();
        this.backgroundColor = rtfCell.getRtfBackgroundColor();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
        for (int i = 0; i < this.content.size(); ++i) {
            ((RtfBasicElement)this.content.get(i)).setInHeader(bl);
        }
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    private byte[] intToByteArray(int n) {
        return DocWriter.getISOBytes(Integer.toString(n));
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

