/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IBuildProcessListener;
import org.tizen.common.builder.dependency.JGraphDependency;
import org.tizen.common.builder.util.DependencyUtil;
import org.tizen.common.file.IResource;
import org.tizen.common.util.Assert;

public class BuildDependencyListener
implements IBuildProcessListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IBuildDependency buildDependency;

    public BuildDependencyListener(IBuildDependency buildDependency) {
        Assert.notNull((Object)buildDependency);
        this.buildDependency = buildDependency;
    }

    @Override
    public void buildSuccess(BuildResult result) {
        this.drawBuildDependencyGraph(result);
    }

    private void drawBuildDependencyGraph(BuildResult result) {
        if (result != null) {
            for (IResource in : result.getInputs()) {
                if (!this.buildDependency.containsVertex(in)) {
                    this.buildDependency.addVertex(in);
                }
                for (IResource out : result.getOutputs(in)) {
                    if (out == null) continue;
                    if (!this.buildDependency.containsVertex(out)) {
                        this.buildDependency.addVertex(out);
                    }
                    this.buildDependency.addEdge(in, out, new JGraphDependency());
                    this.logger.trace("Draw edge : ({}) {}", (Object)in.getFileHandler().toString(), (Object)in.getPath());
                    this.logger.trace("         => ({}) {}", (Object)out.getFileHandler().toString(), (Object)out.getPath());
                }
            }
        }
    }

    @Override
    public void buildError(BuildResult result) {
    }

    public IBuildDependency getBuildDependency() {
        return this.buildDependency;
    }

    @Override
    public void buildWarning(BuildResult result) {
        this.buildSuccess(result);
    }

    @Override
    public void preBuild(IResource resource) {
        try {
            DependencyUtil.removeDependencyTargets(this.buildDependency, resource, false);
        }
        catch (IOException iOException) {
            this.logger.error("{} cannot remove.", (Object)(String.valueOf(resource.getFileHandler().getCurrentWorkingDirectory()) + File.separator + resource.getPath()));
        }
    }

    @Override
    public void postBuild(IResource resource) {
    }
}

