/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder.core;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.ITemplateProvider;

public abstract class TemplateEngineBuilder
extends AbstractBuilder {
    protected ITemplateEngine templateEngine;

    public TemplateEngineBuilder(ITemplateEngine engine, ITemplateProvider templateProvider, String outputPath) {
        this(engine, outputPath);
        this.templateEngine.setTemplateProvider(templateProvider);
    }

    public TemplateEngineBuilder(ITemplateEngine engine, String outputPath) {
        super(outputPath);
        this.templateEngine = engine;
    }

    public TemplateEngineBuilder(ITemplateEngine engine, FileHandler fh) {
        super(fh);
        this.templateEngine = engine;
    }

    @Override
    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult buildResult;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            String templateKey = this.getTemplateKey(resource);
            this.templateEngine.generate(templateKey, this.getModelProvider(), (OutputStream)baos);
            BuildResult ret = new BuildResult(BuildResult.Status.SUCCESS);
            this.addOutputResource(ret, resource, resource.getPath(), baos.toByteArray());
            buildResult = ret;
        }
        catch (Exception e) {
            try {
                throw new BuildException(e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{baos});
                throw throwable;
            }
        }
        IOUtil.tryClose((Object[])new Object[]{baos});
        return buildResult;
    }

    protected abstract String getTemplateKey(IResource var1);

    protected abstract IModelProvider getModelProvider();
}

