/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.project.util;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.project.CommonProjectConstants;
import org.tizen.common.project.util.Messages;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FilenameUtil;

public abstract class ProjectValidationUtil {
    public static boolean isValidName(String projectName) {
        Assert.notNull((Object)projectName);
        return projectName.matches(CommonProjectConstants.PROJECT_NAME_PATTERN);
    }

    public static boolean isValidNameForAppID(String projectName) {
        Assert.notNull((Object)projectName);
        return projectName.matches(CommonProjectConstants.PROJECT_NAME_PATTERN_FOR_APPID);
    }

    public static boolean isValidNameLength(String projectName) {
        Assert.notNull((Object)projectName);
        int nameLength = projectName.length();
        return 3 <= nameLength && nameLength <= 50;
    }

    public static String getInvalidChar(URI location) {
        Assert.notNull((Object)location);
        if ("file".equals(location.getScheme())) {
            Path pathPart = new Path(location.getSchemeSpecificPart());
            String[] stringArray = pathPart.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                char[] cArray = CommonProjectConstants.INVALID_RESOURCE_CHARACTERS;
                int n3 = CommonProjectConstants.INVALID_RESOURCE_CHARACTERS.length;
                int n4 = 0;
                while (n4 < n3) {
                    char invalidChar = cArray[n4];
                    if (segment.indexOf(invalidChar) != -1) {
                        return String.valueOf(invalidChar);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return "";
    }

    public static boolean isExistProject(String name, URI location) {
        Assert.notNull((Object)location);
        IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (handle.exists()) {
            return true;
        }
        File locationFile = new File(location);
        String projectPath = FilenameUtil.addTailingPath((String)locationFile.getAbsolutePath(), (String)".project");
        return locationFile.exists() && new File(projectPath).exists();
    }

    public static String getValidatedMsgAboutLocation(String projectName, URI projectLocation) {
        if (!ProjectValidationUtil.isValidNameLength(projectName)) {
            return NLS.bind((String)Messages.ValidationUtil_InvalidProjectNameLength, (Object)2, (Object)51);
        }
        if (!ProjectValidationUtil.isValidName(projectName)) {
            return Messages.ValidationUtil_InvalidProjectName;
        }
        if (ProjectValidationUtil.isExistProject(projectName, projectLocation)) {
            return Messages.ValidationUtil_AlreadyExistProject;
        }
        return "";
    }
}

