/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.tizen.common.classloader.AbstractClassSource;
import org.tizen.common.classloader.ClassSource;

public class CompositeClassSource
extends AbstractClassSource
implements ClassSource {
    protected final ArrayList<ClassSource> sources = new ArrayList();

    public CompositeClassSource(ClassSource ... sources) {
        this.sources.addAll(Arrays.asList(sources));
    }

    @Override
    public URL getResource(String path) throws IOException {
        for (ClassSource source : this.sources) {
            URL url = source.getResource(path);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Collection<URL> getResources(String path) throws IOException {
        ArrayList<URL> ret = new ArrayList<URL>();
        for (ClassSource source : this.sources) {
            if (source instanceof CompositeClassSource) {
                ret.addAll(((CompositeClassSource)source).getResources(path));
                continue;
            }
            URL url = source.getResource(path);
            if (url == null) continue;
            ret.add(url);
        }
        return ret;
    }
}

