/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.AttributeContainer;
import org.tizen.common.verrari.Condition;
import org.tizen.common.verrari.SearchableRealm;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.realm.JarRealm;

public class JarSearchableRealm
extends JarRealm
implements SearchableRealm {
    @Override
    public Collection<AttributeContainer> search(Condition condition) throws IOException {
        HashSet<AttributeContainer> ret;
        block14: {
            URL url;
            ret = new HashSet<AttributeContainer>();
            String type = this.getAttribute("search-query-type");
            String urlStr = this.getAttribute("search-query-url");
            this.logger.debug("Type :{}, URL :{}", (Object)type, (Object)urlStr);
            if (!"directory".equals(type)) break block14;
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL :" + urlStr, e);
            }
            if (!"file".equals(url.getProtocol())) {
                throw new UnsupportedOperationException("Check search url. It must start with \"file://\"");
            }
            Condition.Operation op = condition.getOperation();
            String keyword = (String)condition.getRight();
            String path = url.getFile();
            File dir = new File(path);
            this.logger.debug("Path :{}", (Object)path);
            File[] files = dir.listFiles();
            if (files == null) break block14;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.logger.debug("File :{}", (Object)file.getCanonicalPath());
                switch (op) {
                    case Contains: {
                        String value;
                        Collection<String> keys;
                        Template template;
                        FileInputStream fileIn = new FileInputStream(file);
                        try {
                            template = this.getTemplate(fileIn);
                            keys = template.getAttributeKeys();
                            for (String key : keys) {
                                value = template.getAttribute(key);
                                if (!value.contains(keyword)) continue;
                                ret.add(template);
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fileIn});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{fileIn});
                        break;
                    }
                    case CaseInsensitiveContains: {
                        String value;
                        Collection<String> keys;
                        Template template;
                        FileInputStream fileIn = new FileInputStream(file);
                        try {
                            template = this.getTemplate(fileIn);
                            keys = template.getAttributeKeys();
                            for (String key : keys) {
                                value = template.getAttribute(key);
                                if (!value.toLowerCase().contains(keyword.toLowerCase())) continue;
                                ret.add(template);
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fileIn});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{fileIn});
                        break;
                    }
                }
                ++n2;
            }
        }
        return ret;
    }
}

