/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.coverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.tizen.common.util.OSChecker;
import org.tizen.core.gputil.IOUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.coverage.GenCoverage;
import org.tizen.ncli.subcommands.coverage.ReportInfo;

public class GenCoverageCommand
extends AbstractSubCommand<GenCoverage> {
    private String covFile;
    private ArrayList<String> projs = new ArrayList();
    private String outFolder;
    private String toolchainPath;
    private String config;

    public void setCovFile(String file) {
        this.covFile = file;
    }

    public void setProjs(String proj) {
        if (proj == null) {
            this.projs = new ArrayList();
        } else {
            String[] projArr = proj.split(",");
            for (int i = 0; i < projArr.length; ++i) {
                projArr[i] = this.workingDir + "/" + projArr[i];
                projArr[i] = projArr[i].replace("\\", "/");
            }
            this.projs = new ArrayList<String>(Arrays.asList(projArr));
        }
    }

    public void setOutFolder(String folder) {
        this.outFolder = folder;
    }

    public void setToolchainPath(String path) {
        this.toolchainPath = path;
    }

    public void setConfig(String conf) {
        this.config = conf;
    }

    void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                this.deleteDir(f);
            }
        }
        file.delete();
    }

    @Override
    protected GenCoverage call() {
        if (this.covFile == null) {
            this.log.trace("Coverage File Not Specified");
            throw new UnexpectedException(2, "Coverage File Not Specified");
        }
        File f = new File(this.covFile);
        if (!f.exists()) {
            this.log.trace("Coverage File Does not exist");
            throw new UnexpectedException(2, "Coverage File Does not exist");
        }
        if (this.toolchainPath == null) {
            this.log.trace("Toolchain Not Specified");
            throw new UnexpectedException(2, "Toolchain Not Specified");
        }
        String llvmCov = this.toolchainPath + "/bin/" + (OSChecker.isWindows() ? "llvm-cov.exe" : "llvm-cov");
        f = new File(llvmCov);
        if (!f.exists()) {
            this.log.trace("llvm-cov does not exist");
            throw new UnexpectedException(2, "Toolchain Folder Does not exist");
        }
        if (this.projs.isEmpty()) {
            this.log.trace("Projects Not Specified for Coverage Generation");
            throw new UnexpectedException(2, "Projects Not Specified for Coverage Generation");
        }
        if (this.outFolder == null) {
            this.log.trace("Output folder not specified");
            throw new UnexpectedException(2, "Output folder not specified");
        }
        f = new File(this.outFolder);
        if (f.exists()) {
            this.deleteDir(f);
        }
        f.mkdirs();
        if (this.workingDir == null) {
            this.log.trace("Workspace directory not specified");
            throw new UnexpectedException(2, "Workspace directory not specified");
        }
        String llvmCovData = this.generateCovData();
        this.generateCovReports(llvmCovData);
        return null;
    }

    private void generateCovReports(String llvmCovData) {
        String utcBinaryPath = "";
        String htmlReportPath = this.outFolder + "/CoverageReport";
        htmlReportPath = htmlReportPath.replace("\\", "/");
        for (String proj : this.projs) {
            if (!this.isUnitTest(proj)) continue;
            String binName = this.getArtifactName(proj);
            if (binName.isEmpty()) break;
            utcBinaryPath = proj + "/" + this.config + "/" + binName;
        }
        if (utcBinaryPath.isEmpty()) {
            throw new UnexpectedException(2, "Unit Test project not specified in the Proj List or Not Exported as CLI Project");
        }
        File file = new File(htmlReportPath);
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        for (String proj : this.projs) {
            File f;
            String execPath = utcBinaryPath;
            if (this.isApp(proj)) {
                execPath = proj + "/" + this.config + "/" + this.getArtifactName(proj);
            }
            if (!(f = new File(execPath)).exists()) {
                System.out.printf("File %s not found%n", execPath);
                continue;
            }
            proj = proj.replace("\\", "/");
            String projName = proj.substring(proj.lastIndexOf("/") + 1);
            String infoLog = String.format("=== Generating Coverage Report for %s ===", projName);
            System.out.println(infoLog);
            this.generateHTMLCovReport(proj, projName, execPath, llvmCovData, htmlReportPath);
        }
        System.out.println("=== Consolidating Reports ===");
        this.generateConsolidatedIndexFile(htmlReportPath);
        System.out.printf("=== Coverage Reports Generated at %s ===%n", htmlReportPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConsolidatedIndexFile(String reportPath) {
        File[] projReportDir = new File(reportPath).listFiles(File::isDirectory);
        String separator = System.getProperty("line.separator");
        File file = new File(reportPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(reportPath + File.separator + "index.html");
        BufferedWriter writer = null;
        try {
            int totalMissLines = 0;
            int totalLines = 0;
            float totalPercent = 0.0f;
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(String.format("<html>" + separator + "<head><h1> <center>Coverage Report</center></h1></head>" + separator + "<body><pre style=\"wod-wrap:break-word; white-space:pre-wrap;font-size:14px\">" + separator, new Object[0]));
            writer.write(String.format("%-40s       Lines      Miss       Cover" + separator, "Project Name"));
            writer.write("------------------------------------------------------------------------------------" + separator);
            for (int i = 0; i < projReportDir.length; ++i) {
                String projName = projReportDir[i].getName();
                File reportFile = new File(projReportDir[i].getAbsolutePath() + "/.report.txt");
                if (!reportFile.exists()) continue;
                ReportInfo info = new ReportInfo(reportFile);
                int lineCount = info.getLineCount();
                int missedCount = info.getMissCount();
                writer.write(separator + String.format("<a href =\"%s/index.html\" style=\"text-decoration: none\">%-40s</a> : %10d%10d%10.2f%%", projName, projName, lineCount, missedCount, Float.valueOf(info.getPercent())));
                totalLines += lineCount;
                totalMissLines += missedCount;
            }
            if (totalLines != 0) {
                totalPercent = (float)((totalLines - totalMissLines) * 100) / (float)totalLines;
            }
            writer.write(separator + "------------------------------------------------------------------------------------" + separator);
            writer.write(separator + String.format("%-40s : %10d%10d%10.2f%%", "TOTAL", totalLines, totalMissLines, Float.valueOf(totalPercent)));
            writer.write("</pre></body>" + separator + "</html>");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{writer});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{writer});
        }
        IOUtil.tryClose((Object[])new Object[]{writer});
    }

    private boolean isUnitTest(String proj) {
        File f = new File(proj + "/unittest.xml");
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getArtifactName(String proj) {
        File propFile = new File(proj, "project_def.prop");
        if (!propFile.exists()) {
            return "";
        }
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        String appName = prop.getProperty("APPNAME");
        if (appName == null) {
            return "";
        }
        return appName.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApp(String proj) {
        File propFile = new File(proj, "project_def.prop");
        if (!propFile.exists()) {
            return false;
        }
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        String appType = prop.getProperty("type");
        if (appType == null) {
            return false;
        }
        return appType.equalsIgnoreCase("app");
    }

    private String generateCovData() {
        String command = this.toolchainPath + "/bin/llvm-profdata";
        File file = new File(this.outFolder + "/coverage.profdata");
        if (file.exists()) {
            file.delete();
        }
        ProcessBuilder pb = new ProcessBuilder(command, "merge", "-o", this.outFolder + "/coverage.profdata", this.covFile);
        File log = new File(this.outFolder + "/.covLog");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        try {
            Process p = pb.start();
            p.waitFor();
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return file.getAbsolutePath();
    }

    private void generateHTMLCovReport(String projPath, String projName, String exePath, String covFilePath, String htmlReportPath) {
        String llvmCovPath = this.toolchainPath + "/bin/llvm-cov";
        ArrayList<String> cmds = new ArrayList<String>();
        ProcessBuilder pb = null;
        StringBuilder sb = null;
        String[] subCmd = new String[8];
        File outF = new File(htmlReportPath + "/" + projName);
        if (outF.exists()) {
            outF.delete();
        }
        outF.mkdirs();
        if (OSChecker.isWindows()) {
            pb = new ProcessBuilder(llvmCovPath, "report", exePath, "-tizen-cov", "-filename-equivalence", "-instr-profile=" + covFilePath, projPath + "/", "-outfile=" + outF.getAbsolutePath() + "/.report.txt");
        } else {
            subCmd[0] = llvmCovPath;
            subCmd[1] = "report";
            subCmd[2] = exePath;
            subCmd[3] = "-tizen-cov";
            subCmd[4] = "-filename-equivalence";
            subCmd[5] = "-instr-profile=" + covFilePath;
            subCmd[6] = projPath + "/";
            subCmd[7] = "-outfile=" + outF.getAbsolutePath() + "/.report.txt";
            sb = new StringBuilder();
            for (String c : subCmd) {
                if (sb.length() != 0) {
                    sb.append(" ");
                }
                sb.append(c);
            }
            cmds.add("/bin/sh");
            cmds.add("-c");
            cmds.add(sb.toString());
            pb = new ProcessBuilder(cmds);
        }
        File log = new File(outF + "/.reportLog");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        try {
            Process p = pb.start();
            p.waitFor();
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (OSChecker.isWindows()) {
            pb = new ProcessBuilder(llvmCovPath, "show", exePath, "-filename-equivalence", "-format=html", "-instr-profile=" + covFilePath, projPath + "/", "-output-dir=" + outF);
        } else {
            cmds.clear();
            subCmd[0] = llvmCovPath;
            subCmd[1] = "show";
            subCmd[2] = exePath;
            subCmd[3] = "-filename-equivalence";
            subCmd[4] = "-format=html";
            subCmd[5] = "-instr-profile=" + covFilePath;
            subCmd[6] = projPath + "/";
            subCmd[7] = "-output-dir=" + outF;
            sb = new StringBuilder();
            for (String c : subCmd) {
                if (sb.length() != 0) {
                    sb.append(" ");
                }
                sb.append(c);
            }
            cmds.add("/bin/sh");
            cmds.add("-c");
            cmds.add(sb.toString());
            pb = new ProcessBuilder(cmds);
        }
        log = new File(outF + "/.covLog");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        try {
            Process p = pb.start();
            p.waitFor();
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

